<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://getwpfunnels.com/
 * @since             1.0.0
 * @package           Wpfunnels_Pro_Integrations
 *
 * @wordpress-plugin
 * Plugin Name:       WPFunnels Pro - Integrations
 * Plugin URI:        https://getwpfunnels.com/
 * Description:       Integrate ⛓️ with your favorite CRM & Email 📧 Automation tools and send buyers' data based on their actions in your sales funnels.
 * Version:           1.2.5
 * Author:            WPFunnels Team
 * Author URI:        https://getwpfunnels.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wpfunnels-pro-integrations
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'WPFNL_PRO_INTEGRATIONS_VERSION', '1.2.5' );

define('WPFNL_PRO_INTEGRATIONS_PRODUCT_ID', 'wpf-integration');
define('WPFNL_PRO_INTEGRATIONS_FILE', __FILE__);
define('WPFNL_PRO_INTEGRATIONS_DIR', plugin_dir_path(WPFNL_PRO_INTEGRATIONS_FILE));
define('WPFNL_PRO_INTEGRATIONS_MAIN_PAGE_SLUG', 'wpfunnels_integrations');

$protocol = ( (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ||  ( !empty($_SERVER['SERVER_PORT'] && $_SERVER['SERVER_PORT'] == 443) ) ) ? "https://" : "http://";
define('WPFNL_PRO_INTEGRATIONS_INSTANCE', str_replace($protocol, "", get_bloginfo('wpurl')));

//license middleman api url
define('WPFNL_PRO_INTEGRATIONS_LICENSE_URL', 'http://license.getwpfunnels.com:8888/api/v1/licence');

//the url where the WooCommerce Software License plugin is being installed
define('WPFNL_PRO_INTEGRATIONS_API_URL', 'https://useraccount.getwpfunnels.com/');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wpfunnels-pro-integrations-activator.php
 */
function activate_wpfunnels_pro_integrations() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/utils/class-wpfunnels-pro-integrations-activator.php';
	Wpfunnels_Pro_Integrations_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wpfunnels-pro-integrations-deactivator.php
 */
function deactivate_wpfunnels_pro_integrations() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/utils/class-wpfunnels-pro-integrations-deactivator.php';
	Wpfunnels_Pro_Integrations_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wpfunnels_pro_integrations' );
register_deactivation_hook( __FILE__, 'deactivate_wpfunnels_pro_integrations' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wpfunnels-pro-integrations.php';


function wpfunnels_pro_integrations_run_updater() {
    new \WPFunnelsPro\Integrations\Wpfnl_Pro_Integrations_Updater(WPFNL_PRO_INTEGRATIONS_API_URL, 'wpfunnels-pro-integrations', 'wpfunnels-pro-integrations/wpfunnels-pro-integrations.php');
}
add_action('after_setup_theme', 'wpfunnels_pro_integrations_run_updater');



/**
 * redirect to license page after plugin activation
 * @since 1.0.10
 */
function wpfnl_pro_integrations_redirect() {
    if( is_plugin_active( 'wpfunnels-pro/wpfnl-pro.php' ) ){
        if (get_option('wpfunnels_pro_integrations_do_activation_redirect', false)) {
            delete_option('wpfunnels_pro_integrations_do_activation_redirect');

            // On these pages, or during these events, postpone the redirect.
            $do_redirect = true;
            if ( wp_doing_ajax() || is_network_admin() ) {
                $do_redirect = false;
            }
            if( $do_redirect ) {
                wp_redirect("admin.php?page=wpf-license");
            }
        }
    }else{
        delete_option('wpfunnels_pro_integrations_do_activation_redirect');
    }
}
add_action('admin_init', 'wpfnl_pro_integrations_redirect');


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wpfunnels_pro_integrations() {

	$plugin = new Wpfunnels_Pro_Integrations();
	$plugin->run();

	$dependecy = new \Wpfnl_Integration_Activation( 'wpfunnels-pro/wpfnl-pro.php', __FILE__, '1.6.8', 'wpfunnels-pro-integrations' );
	if ( ! function_exists( 'get_plugins' ) || ! function_exists( 'is_plugin_active' ) ) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    
    $installed_plugins = get_plugins();
    if( !isset($installed_plugins['wpfunnels/wpfnl.php']) || !is_plugin_active( 'wpfunnels/wpfnl.php' ) ){
        $dependecy::deactivate_self( 'wpfunnels-pro-integrations/wpfunnels-pro-integrations.php' );
    }

	$license   = new \WPFunnelsPro\Integrations\Wpfnl_Pro_Integrations_Licensing();
}

run_wpfunnels_pro_integrations();
