<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://getwpfunnels.com/
 * @since      1.0.0
 *
 * @package    Wpfunnels_Pro_Integrations
 * @subpackage Wpfunnels_Pro_Integrations/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Wpfunnels_Pro_Integrations
 * @subpackage Wpfunnels_Pro_Integrations/includes
 * @author     WPFunnels Team <support@getwpfunnels.com>
 */
class Wpfunnels_Pro_Integrations_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'wpfunnels-pro-integrations',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
