<?php

namespace WPFunnelsPro\Integartions\SendInBlue;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use GuzzleHttp\Exception\GuzzleException;

class Wpfnl_Integartion_SendInBlue_functions
{


    /**
     * Get lists
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_lists(){
        
        try{
            $config = self::auth_config();
            if( $config ){
                $api_instance = new \SendinBlue\Client\Api\ContactsApi(new \GuzzleHttp\Client(), $config);
            
                $lists = $api_instance->getLists();
                if( isset($lists['lists']) ){
                    $formatted_lists = [];
                    foreach( $lists['lists'] as $key=>$list ){
                        if( $list['id'] ){
                            $formatted_lists[$list['id']] = [
                                'value' => $list['name'] 
                            ];
                        }
                    }
                    return $formatted_lists;
                }
            }
        }catch(GuzzleException $e){
            error_log(print_r($e,1));
            return [];
        }catch( \SendinBlue\Client\ApiException $e ){
            error_log(print_r($e->getMessage(),1));
            return [];
        }
        return [];
        
    }

    /**
     * Get active campaign tags
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_tags(){
        try{
           

        }catch(GuzzleException $e){
            error_log(print_r($e,1));
            return [];
        }
        return [];
    } 


    /**
     * get config data
     * 
     * @return Array
     * @since 1.0.0
     * 
     */
    public static function auth_config(){

        try{
            $creds = get_option( '_wpfnl_addons_cred' );
            if( $creds ){
                if( isset($creds['sendinblue']) && isset($creds['sendinblue']['sendinblue_api']) && isset($creds['sendinblue']['status']) && 'active' === $creds['sendinblue']['status'] && isset($creds['sendinblue']['sendinblue_status']) && 'active' === $creds['sendinblue']['sendinblue_status'] ){
               
                    $sendinblue_api = Wpfunnels_Aes_Ctr::decrypt( $creds['sendinblue']['sendinblue_api'], WPFNL_SECURITY_KEY, 256 );
                    
                    $response= \SendinBlue\Client\Configuration::getDefaultConfiguration()->setApiKey("api-key", $sendinblue_api);
                    $response= \SendinBlue\Client\Configuration::getDefaultConfiguration()->setApiKey("partner-key", $sendinblue_api);
                    return $response;
                }
            }
            
        }catch( \Exception $e ){
            error_log(print_r($e->getMessage(),1));
        }
        catch( \SendinBlue\Client\ApiException $e ){
            error_log(print_r($e->getMessage(),1));
        }
       
        return [];
    } 


    /**
     * maybe active campaign settings enable
     * 
     * @return Bool
     * @since 1.0.
     */
    public static function maybe_sendinblue_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['sendinblue']) && isset($creds['sendinblue']['status'])  && isset($creds['sendinblue']['sendinblue_api']) && isset($creds['sendinblue']['sendinblue_api'])){
                if( 'active' == $creds['sendinblue']['sendinblue_status'] && 'active' == $creds['sendinblue']['status'] ){
                    return true;
                }
            }
        }
        return false;
    }


}