<?php

namespace WPFunnelsPro\Integartions\Mailpoet;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;


class Wpfnl_Integartion_Mailpoet_functions
{


    /**
     * Get mailpoet lists
     * 
     * @since 1.0.0  
     */
    public static function get_lists(){
        if( self::maybe_mailpoet_active() ){
            if (class_exists(\MailPoet\API\API::class)) {
                $mailpoet_api = \MailPoet\API\API::MP('v1');
                $lists = $mailpoet_api->getLists();
                if( is_array($lists) ){
                    $response = [];
                    foreach( $lists as $list ){
                        $response[$list['id']] = [
                            'value' => $list['name']
                        ];
                    }
                    return $response;
                }
            }
           
        }
        return [];
    }


    /**
     * may be mailpoet plugin activated
     * 
     * @return Bool
     */
    public static function maybe_mailpoet_active(){
        if( is_plugin_active( 'mailpoet/mailpoet.php' ) ){
            return true;
        }
        return false;
    }


    /**
     * maybe mailpoet settings enable
     * 
     * @return Bool
     */
    public static function maybe_mailpoet_enable(){
        if( self::maybe_mailpoet_active() ){
            if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
                $creds = get_option( '_wpfnl_addons_cred' );
                if( isset($creds['mailpoet']['status']) && 'active' == $creds['mailpoet']['status']  ) {
                    return true;
                }
            }
        }
        return false;
    }



}