<?php

namespace WPFunnelsPro\Integartions\Mailerlite;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use GuzzleHttp\Exception\GuzzleException;

class Wpfnl_Integartion_Mailerlite_functions
{


    /**
     * Get lists
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_lists(){
        $response = [];
        try{
            $creds = get_option( '_wpfnl_addons_cred' );
            if( $creds && isset($creds['mailerlite']['mailerlite_api']) ){
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $groups = $client->request('GET', 'https://api.mailerlite.com/api/v2/groups', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                        'X-MailerLite-ApiKey' => Wpfunnels_Aes_Ctr::decrypt( $creds['mailerlite']['mailerlite_api'], WPFNL_SECURITY_KEY, 256 ),
                    ],
                ]);

                if( 200 == $groups->getStatusCode() ){
                    $result = json_decode($groups->getBody()->getContents());
                    if( is_array($result ) ){
                        foreach( $result as $group ){
                            if( isset($group->id, $group->name) ){
                                $response[$group->id] = [
                                    'value' => $group->name
                                ];
                            }
                        }
                        return $response;
                    }
                }
            }
           
        }catch(GuzzleException $e){
            error_log(print_r($e,1));
            return [];
        }catch( \SendinBlue\Client\ApiException $e ){
            error_log(print_r($e->getMessage(),1));
            return [];
        }catch( \Exception $e ){
            error_log(print_r($e->getMessage(),1));
            return [];
        }
    }

    /**
     * Get mailerlite tags
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_tags(){
        try{
           

        }catch(GuzzleException $e){
            error_log(print_r($e,1));
            return [];
        }
        return [];
    } 


    /**
     * get config data
     * 
     * @return Array
     * @since 1.0.0
     * 
     */
    public static function auth_config(){

        try{
            $creds = get_option( '_wpfnl_addons_cred' );
            if( $creds && isset($creds['mailerlite']['mailerlite_api']) ){
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $response = $client->request('GET', 'https://api.mailerlite.com/api/v2/me', [
                'headers' => [
                    'Accept' => 'application/json',
                    'X-MailerLite-ApiDocs' => 'true',
                    'X-MailerLite-ApiKey' => Wpfunnels_Aes_Ctr::decrypt( $creds['mailerlite']['mailerlite_api'], WPFNL_SECURITY_KEY, 256 )
                ],
                ]);
                
                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( $result ){
                    }
                }
            }
            
        }catch( \Exception $e ){
            error_log(print_r($e->getMessage(),1));
        }
        catch( \SendinBlue\Client\ApiException $e ){
            error_log(print_r($e->getMessage(),1));
        }
       
        return [];
    } 


    /**
     * maybe mailerlite settings enable
     * 
     * @return Bool
     * @since 1.0.
     */
    public static function maybe_mailerlite_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['mailerlite']) && isset($creds['mailerlite']['status'])  && isset($creds['mailerlite']['mailerlite_api']) && isset($creds['mailerlite']['mailerlite_api'])){
                if( 'active' == $creds['mailerlite']['mailerlite_status'] && 'active' == $creds['mailerlite']['status'] ){
                    return true;
                }
            }
        }
        return false;
    }


}