<?php

namespace WPFunnelsPro\Integartions\Mailchimp;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;

class Wpfnl_Integartion_Mailchimp_functions
{


    /**
     * Get mailchimp tags by list ID
     * 
     * @param Array 
     * @return Array
     * @since 1.0.0
     */
    public static function get_mailchimp_tags( $list_data = [] ){
        $response = [];
        if( !empty($list_data) ){
            $mailchimp = self::get_mailchimp_obj();
            $config_data = self::get_config_data();
            if( $config_data ){
                $result = self::set_config_data( $config_data, $mailchimp );
                if( $result && isset($list_data['list_id'])){
                    $list_id         = $list_data['list_id'];
                    try{
                        $segments = $mailchimp->lists->listSegments($list_id, $fields = null, $exclude_fields = null, $count = '1000');
                        if( isset($segments->segments) ){
                            if( is_array($segments->segments) && !empty($segments->segments) ){
                                foreach( $segments->segments as $segment ){
                                    $response[$segment->id] = $segment->name;
                                }
                            } 
                        }
                    }catch (\MailchimpMarketing\ApiException $e) {
                        return $response;
                    }
                }
            }
            
        }   
        return $response;
    }


    /**
     * Get config data from option table
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_config_data(){

        $creds = get_option( '_wpfnl_addons_cred' );
        if( $creds ){
            if( isset($creds['mailchimp']) && isset($creds['mailchimp']['mailchimp_apikey']) && isset($creds['mailchimp']['mailchimp_server'])){
                $config_data = [
                    'api_key' => Wpfunnels_Aes_Ctr::decrypt( $creds['mailchimp']['mailchimp_apikey'], WPFNL_SECURITY_KEY, 256 ),
                    'server' =>  Wpfunnels_Aes_Ctr::decrypt( $creds['mailchimp']['mailchimp_server'], WPFNL_SECURITY_KEY, 256 ),
                ];
                return $config_data;
            }
        }
        return false;
    }



    /**
     * Get mailchimp object
     * 
     * @return Object
     * @since 1.0.0
     */
    public static function get_mailchimp_obj(){
        try{
            $mailchimp = new \WPFunnelsPro\Integrations\MailchimpMarketing\ApiClient();
            return $mailchimp;
        }catch (\WPFunnelsPro\Integrations\MailchimpMarketing\ApiException $e) {
            error_log(print_r($e->getMessage(),1));
            return false;
        }
    }


    /**
     * Set config data for mailchimp
     * 
     * @param Array 
     * @param Object 
     * @since 1.0.0
     */
    public static function set_config_data( $config_data = [], $mailchimp = [] ){

        if( !empty($mailchimp) && !empty($config_data) ){
            if( $mailchimp && isset($config_data['api_key']) && $config_data['api_key'] && isset($config_data['server']) && $config_data['server'] ){
                try{
                    $mailchimp->setConfig([
                        'apiKey' => $config_data['api_key'],
                        'server' => $config_data['server']
                    ]);
                    $response = $mailchimp->root->getRoot();
                    return $response;
                }catch (\MailchimpMarketing\ApiException $e) {
                    error_log(print_r($e->getMessage(),1));
                    return false;
                }catch( \GuzzleHttp\Exception\RequestException $e ){
                    error_log(print_r($e->getMessage(),1));
                    return false;
                }
            }
        }
    }

    /**
     * Get mailchimp lists/audience by mailchimp object
     * 
     * @param Object
     * @return Array
     * @since 1.0.0
     * 
     */
    public static function get_lists( $mailchimp = [] ){
        try{
            $response = $mailchimp->lists->getAllLists();
            if( $response ){
                if( isset($response->lists) ){
                    if( is_array($response->lists) ){
                        $lists = $response->lists;
                        $response = [];
                        foreach( $lists as $list ){
                            $response[$list->id] = [
                                'value' => $list->name,
                                'email' => isset($list->campaign_defaults) && isset($list->campaign_defaults->from_email) ? $list->campaign_defaults->from_email : '',
                            ];
                        }
                        return $response;
                    }
                }
            }
        }catch (\MailchimpMarketing\ApiException $e) {
            error_log(print_r($e->getMessage(),1));
            return [];
        }
        return [];
    }



    /**
     * maybe mailchimp settings enable
     * 
     * @return Bool
     */
    public static function maybe_mailchimp_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( $creds ){
                if( isset($creds['mailchimp']['status']) && isset($creds['mailchimp']['mailchimp_status']) &&  $creds['mailchimp']['status'] == 'active' && $creds['mailchimp']['mailchimp_status'] == 'active' ){
                    return true;
                }
            }
        }
        return false;
    }

}