<?php

namespace WPFunnelsPro\Integartions\Hubspot;

use Exception;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;


class Wpfnl_Integartion_Hubspot_functions
{
    /**
     * Get lists from Hubspot account
     * 
     * @return Array|bool
     * @since 1.2.0
     */
    public static function get_lists(){
        $creds = get_option( '_wpfnl_addons_cred' );
        if( $creds && isset($creds['hubspot'],$creds['hubspot']['hubspot_status'],$creds['hubspot']['hubspot_api'],$creds['hubspot']['status'])  ){
            $url = self::hubspot_authentication_url();
            if( $url ) {
                try {
                    $response = wp_remote_request($url.'contacts/v1/lists/static', [
                        'headers' => [
                            'Authorization' => 'Bearer ' .  Wpfunnels_Aes_Ctr::decrypt( $creds['hubspot']['hubspot_api'], WPFNL_SECURITY_KEY, 256 ),
                            'Content-Type' => 'application/json',
                        ],
                    ]);

                    $status_code = wp_remote_retrieve_response_code($response);

                    if( 200 === $status_code){
                        $response_body = wp_remote_retrieve_body($response);

                        $result = json_decode($response_body);
                        if( !empty($result->lists) && is_array($result->lists) ){
                            $formatted_lists = [];
                            foreach( $result->lists as $list ){
                                if( !empty($list->name) && !empty($list->listId) ){
                                    $formatted_lists[$list->listId] = [
                                        'list_id' => $list->listId,
                                        'value'   => $list->name 
                                    ];
                                }
                            }
                            return $formatted_lists;
                        }
                    }
                }catch (\Exception $e) {
                    error_log(print_r($e->getMessage(),1));
                }
            }
        }
        return false;
    }

    /**
     * Get tags from encharge account
     * 
     * @return Array
     * @since 1.2.0
     */
    public static function get_tags(){
        return false;
    }


    /**
     * Hubspot authentication url
     * @return String
     * 
     * @since 1.2.0
     */
    public static function hubspot_authentication_url(){
        $auth_url = 'https://api.hubapi.com/';
        return $auth_url;
    }


    /**
     * Check hubspot settings enable
     * 
     * @return Bool
     * @since 1.2.0
     */
    public static function maybe_hubspot_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['hubspot']) && isset($creds['hubspot']['status']) && isset($creds['hubspot']['hubspot_status']) && isset($creds['hubspot']['hubspot_api'])){
                if( 'active' === $creds['hubspot']['hubspot_status'] && 'active' === $creds['hubspot']['status'] ){
                    return true;
                }
            }
        }
        return false;;
    }
}