<?php

namespace WPFunnelsPro\Integartions\GetResponse;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use Guzzlehttp\Exception\GuzzleException;

class Wpfnl_Integartion_GetResponse_functions
{

    /**
     * Get lists from GetResponse account
     * 
     * @return Array
     * @since 1.0.11
     */
    public static function get_lists(){
        try {
            $creds = get_option( '_wpfnl_addons_cred' );
            
            if( $creds && isset($creds['getresponse'],$creds['getresponse']['getresponse_status'],$creds['getresponse']['getresponse_api'],$creds['getresponse']['status'])  ){
                $url = self::getresponse_authentication_url();
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $response = $client->request('GET', "$url"."campaigns", [
                    'headers' => [
                        'Content-Type'      => 'application/json',
                        'X-Auth-Token'      => 'api-key '. Wpfunnels_Aes_Ctr::decrypt( $creds['getresponse']['getresponse_api'], WPFNL_SECURITY_KEY, 256 ),
                    ],
                ]);
                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( is_array($result ) ){
                        $formatted_lists = [];
                        foreach( $result as $list ){
                            if( !empty($list->campaignId) ){
                                $formatted_lists[$list->campaignId] = [
                                    'value' => $list->name 
                                ];
                            }
                        }
                        return $formatted_lists;
                    }
                    
                }
                
            }
        }catch (\Exception $e) {
			error_log(print_r($e->getMessage(),1));
        }catch (GuzzleException $e) {
			error_log(print_r($e->getMessage(),1));
        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
			error_log(print_r($e->getMessage(),1));
        }
        return [];
        
    }


    /**
     * Get tags from GetResponse account
     * 
     * @return Array
     * @since 1.0.11
     */
    public static function get_tags(){
        try {
            $creds = get_option( '_wpfnl_addons_cred' );
            
            if( $creds && isset($creds['getresponse'],$creds['getresponse']['getresponse_status'],$creds['getresponse']['getresponse_api'],$creds['getresponse']['status'])  ){
                $url = self::getresponse_authentication_url();
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $response = $client->request('GET', "$url"."tags", [
                    'headers' => [
                        'Content-Type'      => 'application/json',
                        'X-Auth-Token'      => 'api-key '. Wpfunnels_Aes_Ctr::decrypt( $creds['getresponse']['getresponse_api'], WPFNL_SECURITY_KEY, 256 ),
                    ],
                ]);
                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( is_array($result) ){
                        $formatted_tags = [];
                        foreach( $result as $tag ){
                            if( !empty($tag->tagId) ){
                                $formatted_tags[$tag->tagId] = $tag->name;
                            }
                        }
                        return $formatted_tags;
                    }
                    
                }
                
            }
        }catch (\Exception $e) {
			error_log(print_r($e->getMessage(),1));
        }catch (GuzzleException $e) {
			error_log(print_r($e->getMessage(),1));
        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
			error_log(print_r($e->getMessage(),1));
        }
        return [];
    }


    /**
     * GetResponse authentication url
     * @return String
     * 
     * @since 1.0.11
     */
    public static function getresponse_authentication_url(){
        $auth_url        = 'https://api.getresponse.com/v3/';
        return $auth_url;
    }


    /**
     * Check getresponse settings enable
     * 
     * @return Bool
     * @since 1.0.11
     */
    public static function maybe_getresponse_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['getresponse']) && isset($creds['getresponse']['status']) && isset($creds['getresponse']['getresponse_status']) && isset($creds['getresponse']['getresponse_api'])){
                if( 'active' == $creds['getresponse']['getresponse_status'] && 'active' == $creds['getresponse']['status'] ){
                    return true;
                }
            }
        }
        return false;;
    }
}