<?php

namespace WPFunnelsPro\Integartions\Encharge;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use Guzzlehttp\Exception\GuzzleException;

class Wpfnl_Integartion_Encharge_functions
{

    /**
     * Get lists from encharge account
     * 
     * @return Array
     * @since 1.0.12
     */
    public static function get_lists(){
       
        return [];
        
    }


    /**
     * Get tags from encharge account
     * 
     * @return Array
     * @since 1.0.12
     */
    public static function get_tags(){
        try {
            $creds = get_option( '_wpfnl_addons_cred' );
            
            if( $creds && isset($creds['encharge'],$creds['encharge']['encharge_status'],$creds['encharge']['encharge_api'],$creds['encharge']['status'])  ){
                $url = self::encharge_authentication_url();
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $response = $client->request('GET', "$url"."tags-management", [
                    'headers' => [
                        'Content-Type'      => 'application/json',
                        'X-Encharge-Token'      => Wpfunnels_Aes_Ctr::decrypt( $creds['encharge']['encharge_api'], WPFNL_SECURITY_KEY, 256 ),
                    ],
                ]);
                
                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( !empty($result->tags) && is_array($result->tags) ){
                        $formatted_tags = [];
                        foreach( $result->tags as $tag ){
                            if( !empty($tag->tag) ){
                                $formatted_tags[$tag->tag] = $tag->tag;
                            }
                        }
                        return $formatted_tags;

                    }
                }
            }
        }catch (\Exception $e) {
			error_log(print_r($e->getMessage(),1));
        }catch (GuzzleException $e) {
			error_log(print_r($e->getMessage(),1));
        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
			error_log(print_r($e->getMessage(),1));
        }
        return [];
    }


    /**
     * Encharge authentication url
     * @return String
     * 
     * @since 1.0.12
     */
    public static function encharge_authentication_url(){
        $auth_url        = 'https://api.encharge.io/v1/';
        return $auth_url;
    }


    /**
     * Check encharge settings enable
     * 
     * @return Bool
     * @since 1.0.12
     */
    public static function maybe_encharge_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['encharge']) && isset($creds['encharge']['status']) && isset($creds['encharge']['encharge_status']) && isset($creds['encharge']['encharge_api'])){
                if( 'active' == $creds['encharge']['encharge_status'] && 'active' == $creds['encharge']['status'] ){
                    return true;
                }
            }
        }
        return false;;
    }
}