<?php

namespace WPFunnelsPro\Integartions\ConstantContact;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use GuzzleHttp\Exception\GuzzleException;

class Wpfnl_Integartion_ConstantContact_functions
{

    /**
     * Get lists
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_lists(){
        
        try {

            $creds = get_option( '_wpfnl_addons_cred' );
            $token = '';
            if( $creds && isset($creds['cc']) && isset($creds['cc']['cc_token']) && isset($creds['cc']['cc_refresh_token']) ){
                self::get_token_by_refresh_token();
                $creds = get_option( '_wpfnl_addons_cred' );
                $token = Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_token'], get_option('_wpfnl_security_key'), 256 );
            }else{
                self::get_access_token();
                $creds = get_option( '_wpfnl_addons_cred' );
                if( $creds && isset($creds['cc']) && isset($creds['cc']['cc_token']) ){
                    $token = Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_token'], get_option('_wpfnl_security_key'), 256 );
                }
            }

            if( $token ){
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $response = $client->request('GET', "https://api.cc.email/v3/contact_lists?include_count=false", [
                    'headers' => [
                        'Content-Type'      => 'application/json',
                        'Authorization'     => 'Bearer '.$token,
                    ],
                ]);

                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( isset($result->lists) ){
                        if( is_array($result->lists) ){
                            $formatted_lists = [];
                            foreach( $result->lists as $list ){
                                if( $list->name ){
                                    $formatted_lists[$list->list_id] = [
                                        'value' => $list->name 
                                    ];
                                }
                            }
                            return $formatted_lists;
                        }
                    }
                }
            
            }
			
		
        }catch (Exception $e) {
			error_log(print_r($e->getMessage(),1));
            echo $e->getMessage();
        }
        return [];
        
    }


    /**
     * Get tags
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_tags(){
        
        try {
			$client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
            $creds = get_option( '_wpfnl_addons_cred' );
            $token = '';
            if( $creds && isset($creds['cc']) && isset($creds['cc']['cc_token']) ){
                self::get_token_by_refresh_token();
                $creds = get_option( '_wpfnl_addons_cred' );
                $token = Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_token'], get_option('_wpfnl_security_key'), 256 );
            }else{
                self::get_access_token();
                $creds = get_option( '_wpfnl_addons_cred' );
                if( $creds && isset($creds['cc']) && isset($creds['cc']['cc_token']) ){
                    $token = Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_token'], get_option('_wpfnl_security_key'), 256 );
                }
            }

            if( $token ){
                $response = $client->request('GET', "https://api.cc.email/v3/contact_tags?include_count=false", [
                    'headers' => [
                        'Content-Type'      => 'application/json',
                        'Authorization'     => 'Bearer '.$token,
                    ],
                ]);

                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( isset($result->tags) ){
                        if( is_array($result->tags) ){
                            $formatted_tags = [];
                            foreach( $result->tags as $tag ){
                                if( $tag->name ){
                                    $formatted_tags[$tag->tag_id] = $tag->name;
                                }
                            }
                            return $formatted_tags;
                        }
                    }
                }
            }
            
        }catch (Exception $e) {
			error_log(print_r($e->getMessage(),1));
            echo $e->getMessage();
        }
        return [];
        
    }


    /**
     * CC authentication
     * 
     * @since 1.0.3
     */
    public static function cc_authentication( $clientId = '' , $redirect_url = '' ){

        if( $clientId && $redirect_url ){
            $scope           = 'account_read+contact_data';
            $state           = uniqid();
            $auth_url        = self::get_cc_authorization_url( $clientId, $redirect_url, $scope, $state );
            return $auth_url;
        }
        return '#';
    }

    /**
     * Get CC authorization url
     * 
     * @param
     * @return String
     * @since 1.0.3
     */
    public static function get_cc_authorization_url( $clientId, $redirectURI, $scope, $state ){
        $baseURL = "https://authz.constantcontact.com/oauth2/default/v1/authorize";
        $authURL = $baseURL . "?client_id=" . $clientId . "&scope=" . $scope . "+offline_access&response_type=code&state=" . $state . "&redirect_uri=" . $redirectURI;
        return $authURL;
    } 


    /**
     * get access token 
     * 
     * @since 1.0.3
     * 
     */
    public static function get_access_token(){
        $creds = get_option( '_wpfnl_addons_cred' );
        if( $creds && isset($creds['cc']) && isset($creds['cc']['cc_code']) && isset($creds['cc']['cc_url']) && isset($creds['cc']['cc_secret']) && isset($creds['cc']['cc_api']) ){
            try{
                $token_url = self::prepare_url_for_token( Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_code'], get_option('_wpfnl_security_key'), 256 ), $creds['cc']['cc_url'] );
                if( $token_url && $creds['cc']['cc_secret'] && $creds['cc']['cc_api'] ){
                    $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                    $response = $client->request('POST', $token_url, [
                        'headers' => [
                            'Content-Type'   => 'application/x-www-form-urlencoded',
                            'Authorization'  => 'Basic '.base64_encode(Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_api'], get_option('_wpfnl_security_key'), 256 ).':'.Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_secret'], get_option('_wpfnl_security_key'), 256 )),
                        ],
                    ]);
                    if( 200 == $response->getStatusCode() ){
                        $result = json_decode($response->getBody()->getContents());
                        if( isset($result->access_token) && isset($result->refresh_token) ){
                            $creds['cc']['cc_token']         = Wpfunnels_Aes_Ctr::encrypt( $result->access_token, get_option('_wpfnl_security_key'), 256 );
                            $creds['cc']['cc_refresh_token'] = Wpfunnels_Aes_Ctr::encrypt( $result->refresh_token, get_option('_wpfnl_security_key'), 256 );
                            update_option( '_wpfnl_addons_cred', $creds );
                            return true;
                        }
                    }

                   
                }
            }catch (Exception $e) {
                error_log(print_r($e->getMessage(),1));
                return false;
            }catch (GuzzleException $e) {
                error_log(print_r($e->getMessage(),1));
                return false;
            }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                error_log(print_r($e->getMessage(),1));
                return false;
            }
            
        }
    } 

    /**
     * get access token by refresh token
     * 
     * @since 1.0.3
     * 
     */
    public static function get_token_by_refresh_token(){
        $creds = get_option( '_wpfnl_addons_cred' );
        if( $creds && isset($creds['cc']) && isset($creds['cc']['cc_code']) && isset($creds['cc']['cc_url']) && isset($creds['cc']['cc_secret']) && isset($creds['cc']['cc_api']) && isset($creds['cc']['cc_refresh_token']) ){
            $token_url = self::prepare_url_for_refresh_token( Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_refresh_token'],get_option('_wpfnl_security_key'), 256) );
            if( $token_url && $creds['cc']['cc_secret'] && $creds['cc']['cc_api'] ){
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                $response = $client->request('POST', $token_url, [
                    'headers' => [
                        'Content-Type'   => 'application/x-www-form-urlencoded',
                        'Authorization'  => 'Basic '.base64_encode(Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_api'], get_option('_wpfnl_security_key'), 256 ).':'.Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_secret'], get_option('_wpfnl_security_key'), 256 )),
                    ],
                ]);
                if( 200 == $response->getStatusCode() ){
                    $result = json_decode($response->getBody()->getContents());
                    if( isset($result->access_token) && isset($result->refresh_token) ){
                        $creds['cc']['cc_token']         = Wpfunnels_Aes_Ctr::encrypt( $result->access_token, get_option('_wpfnl_security_key'), 256 );
                        $creds['cc']['cc_refresh_token'] = Wpfunnels_Aes_Ctr::encrypt( $result->refresh_token, get_option('_wpfnl_security_key'), 256 );
                        update_option( '_wpfnl_addons_cred', $creds );
                    }
                }
            }
        }
    }


    /**
     * prepare url for access token
     * 
     * @since 1.0.2
     * 
     */
    public static function prepare_url_for_token( $code, $redirect_url ){
        
        if( $code && $redirect_url ){
            $baseURL = "https://authz.constantcontact.com/oauth2/default/v1/token";
            $token_url = $baseURL."?code=".$code."&redirect_uri=".$redirect_url."&grant_type=authorization_code";
            return $token_url;
        }
        return false;
    }


    /**
     * prepare url for access token
     * 
     * @since 1.0.2
     * 
     */
    public static function prepare_url_for_refresh_token( $refresh_token ){
        
        if( $refresh_token ){
            $baseURL = "https://authz.constantcontact.com/oauth2/default/v1/token";
            $token_url = $baseURL."?refresh_token=".$refresh_token."&grant_type=refresh_token";
            return $token_url;
        }
        return false;
    }



    /**
     * maybe constant contact settings enable
     * 
     * @return Bool
     * @since 1.0.3
     */
    public static function maybe_constant_contact_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['cc']) && isset($creds['cc']['status']) && isset($creds['cc']['cc_status'])  && isset($creds['cc']['cc_url']) && isset($creds['cc']['cc_api'])){
                if( 'active' == $creds['cc']['cc_status'] && 'active' == $creds['cc']['status'] ){
                    return true;
                }
            }
        }
        return false;
    }
}