<?php

namespace WPFunnelsPro\Integartions\Aweber;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use Guzzlehttp\Exception\GuzzleException;

class Wpfnl_Integartion_Aweber_functions
{

    /**
     * Get lists
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_lists(){
        try {
            $creds = get_option( '_wpfnl_addons_cred' );
            $token = '';
            if( $creds && isset($creds['aweber']) && isset($creds['aweber']['aweber_token']) && isset($creds['aweber']['aweber_refresh_token']) ){
                self::get_token_by_refresh_token();
                $creds = get_option( '_wpfnl_addons_cred' );
                $token = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_token'], get_option('_wpfnl_security_key'), 256 );
               
            }else{
                self::get_access_token();
                $creds = get_option( '_wpfnl_addons_cred' );
                if( $creds && isset($creds['aweber']) && isset($creds['aweber']['aweber_token']) ){
                    $token = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_token'], get_option('_wpfnl_security_key'), 256 );
                }
            }
            
            
            if( $token ){
                $client = new \WPFunnelsPro\Integrations\Guzzlehttp\Client();
                $account_id = self::get_account( $client, $token );
                if( $account_id ){
                    $response = $client->request('GET', "https://api.aweber.com/1.0/accounts/".$account_id."/lists", [
                        'headers' => [
                            'Content-Type'      => 'application/json',
                            'Authorization'     => 'Bearer '.$token,
                        ],
                    ]);
                    if( 200 == $response->getStatusCode() ){
                        $result = json_decode($response->getBody()->getContents());
                        if( isset($result->entries) ){
                            if( is_array($result->entries) ){
                                $formatted_lists = [];
                                foreach( $result->entries as $list ){
                                    if( $list->name ){
                                        $formatted_lists[$list->id] = [
                                            'value' => $list->name 
                                        ];
                                    }
                                }
                                return $formatted_lists;
                            }
                        }
                    }
                }
            }
        }catch (\Exception $e) {
			error_log(print_r($e->getMessage(),1));
            echo $e->getMessage();
        }catch (GuzzleException $e) {
			error_log(print_r($e->getMessage(),1));
            echo $e->getMessage();
        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
			error_log(print_r($e->getMessage(),1));
            echo $e->getMessage();
        }
        return [];
        
    }


    /**
     * Get accounts
     * 
     * @param Object
     * @param String
     * 
     * @return Mix
     */
    public static function get_account( $client, $token ){
        try{

            $response = $client->request('GET', "https://api.aweber.com/1.0/accounts", [
                'headers' => [
                    'Content-Type'      => 'application/json',
                    'Authorization'     => 'Bearer '.$token,
                ],
            ]);
            if( 200 == $response->getStatusCode() ){
                $result = json_decode($response->getBody()->getContents());
                if( isset($result->entries) ){
                    if( is_array($result->entries) ){
                        $account_id = '';
                        foreach( $result->entries as $entrie ){
                            if( $entrie->id ){
                                $account_id = $entrie->id;
                            }
                        }
                        return $account_id;
                    }
                    return false;
                }
            }
            
        }catch (\Exception $e) {
			error_log(print_r($e->getMessage(),1));
            return false;
           
        }catch (GuzzleException $e) {
			error_log(print_r($e->getMessage(),1));
            return false;
        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
			error_log(print_r($e->getMessage(),1));
            return false;
        }
        
    }


    /**
     * Get tags
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_tags(){
        return [];
    }


    /**
     * CC authentication
     * 
     * @since 1.0.3
     */
    public static function aweber_authentication( $clientId = '' , $redirect_url = '' ){

        if( $clientId && $redirect_url ){
            $scope           = 'account.read+list.read+subscriber.read+subscriber.write';
            $state           = uniqid();
            $auth_url        = self::get_aweber_authorization_url( $clientId, $redirect_url, $scope, $state );
            return $auth_url;
        }
        return '#';
    }

    /**
     * Get CC authorization url
     * 
     * @param
     * @return String
     * @since 1.0.3
     */
    public static function get_aweber_authorization_url( $clientId, $redirectURI, $scope, $state ){
        $baseURL = "https://auth.aweber.com/oauth2/authorize";
        $authURL = $baseURL . "?client_id=" . $clientId . "&scope=" . $scope . "&response_type=code&state=" . $state . "&redirect_uri=" . $redirectURI;
        return $authURL;
    } 


    /**
     * get access token 
     * 
     * @since 1.0.3
     * 
     */
    public static function get_access_token(){
        $creds = get_option( '_wpfnl_addons_cred' );
        if( $creds && isset($creds['aweber']) && isset($creds['aweber']['aweber_code']) && isset($creds['aweber']['aweber_url']) && isset($creds['aweber']['aweber_secret']) && isset($creds['aweber']['aweber_api']) ){
            try{
                $token_url = self::prepare_url_for_token( Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_code'], get_option('_wpfnl_security_key'), 256 ), $creds['aweber']['aweber_url'] );
                
                if( $token_url && $creds['aweber']['aweber_secret'] && $creds['aweber']['aweber_api'] ){
                    $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                    $response = $client->request('POST', $token_url, [
                        'headers' => [
                            'Content-Type'   => 'application/x-www-form-urlencoded',
                            'Authorization'  => 'Basic '.base64_encode(Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_api'], get_option('_wpfnl_security_key'), 256 ).':'.Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_secret'], get_option('_wpfnl_security_key'), 256 )),
                        ],
                    ]);
                   
                    if( 200 == $response->getStatusCode() ){
                        $result = json_decode($response->getBody()->getContents());
                        
                        if( isset($result->access_token) && isset($result->refresh_token) ){
                            
                            $creds['aweber']['aweber_token']         = Wpfunnels_Aes_Ctr::encrypt( $result->access_token, get_option('_wpfnl_security_key'), 256 );
                            $creds['aweber']['aweber_refresh_token'] = Wpfunnels_Aes_Ctr::encrypt( $result->refresh_token, get_option('_wpfnl_security_key'), 256 );
                            update_option( '_wpfnl_addons_cred', $creds );
                            
                            return true;
                        }
                    }

                   
                }
            }catch (\Exception $e) {
                error_log(print_r($e->getMessage(),1));
                return false;
            }catch (GuzzleException $e) {
                error_log(print_r($e->getMessage(),1));
                return false;
            }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                error_log(print_r($e->getMessage(),1));
                return false;
            }
            
        }
    } 

    /**
     * get access token by refresh token
     * 
     * @since 1.0.3
     * 
     */
    public static function get_token_by_refresh_token(){
        try{
            $creds = get_option( '_wpfnl_addons_cred' );
            if( $creds && isset($creds['aweber']) && isset($creds['aweber']['aweber_code']) && isset($creds['aweber']['aweber_url']) && isset($creds['aweber']['aweber_secret']) && isset($creds['aweber']['aweber_api']) && isset($creds['aweber']['aweber_refresh_token']) ){
                $refresh_token = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_refresh_token'], get_option('_wpfnl_security_key'), 256 );
              
                $token_url = self::prepare_url_for_refresh_token( $refresh_token );
                
                if( $token_url && $creds['aweber']['aweber_secret'] && $creds['aweber']['aweber_api'] ){

                    $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                    $response = $client->request('POST', $token_url, [
                        'headers' => [
                            'Content-Type'   => 'application/x-www-form-urlencoded',
                            'Authorization'  => 'Basic '.base64_encode(Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_api'], get_option('_wpfnl_security_key'), 256 ).':'.Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_secret'], get_option('_wpfnl_security_key'), 256 )),
                        ],
                    ]);
                
                    if( 200 == $response->getStatusCode() ){
                        $result = json_decode($response->getBody()->getContents());
                        if( isset($result->access_token) && isset($result->refresh_token) ){
                            $creds['aweber']['aweber_token']         = Wpfunnels_Aes_Ctr::encrypt( $result->access_token, get_option('_wpfnl_security_key'), 256 );
                            $creds['aweber']['aweber_refresh_token'] = Wpfunnels_Aes_Ctr::encrypt( $result->refresh_token, get_option('_wpfnl_security_key'), 256 );
                            update_option( '_wpfnl_addons_cred', $creds );
                        }
                    }
                }
            }
        }catch (\Exception $e) {
            error_log(print_r($e->getMessage(),1));
            return false;
        }catch (GuzzleException $e) {
            error_log(print_r($e->getMessage(),1));
            return false;
        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
            error_log(print_r($e->getMessage(),1));
            return false;
        }
    }


    /**
     * prepare url for access token
     * 
     * @since 1.0.2
     * 
     */
    public static function prepare_url_for_token( $code, $redirect_url ){
        
        if( $code && $redirect_url ){
            $baseURL = "https://auth.aweber.com/oauth2/token";
            $token_url = $baseURL."?code=".$code."&redirect_uri=".$redirect_url."&grant_type=authorization_code";
            return $token_url;
        }
        return false;
    }


    /**
     * prepare url for access token
     * 
     * @since 1.0.2
     * 
     */
    public static function prepare_url_for_refresh_token( $refresh_token ){
        
        if( $refresh_token ){
            $baseURL = "https://auth.aweber.com/oauth2/token";
            $token_url = $baseURL."?refresh_token=".$refresh_token."&grant_type=refresh_token";
            return $token_url;
        }
        return false;
    }



    /**
     * maybe constant contact settings enable
     * 
     * @return Bool
     * @since 1.0.3
     */
    public static function maybe_aweber_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['aweber']) && isset($creds['aweber']['status']) && isset($creds['aweber']['aweber_status'])  && isset($creds['aweber']['aweber_url']) && isset($creds['aweber']['aweber_api'])){
                if( 'active' == $creds['aweber']['aweber_status'] && 'active' == $creds['aweber']['status'] ){
                    return true;
                }
            }
        }
        return false;;
    }
}