<?php

namespace WPFunnelsPro\Integartions\ActiveCampaign;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Wpfnl_Integartion_functions;
use GuzzleHttp\Exception\GuzzleException;

class Wpfnl_Integartion_ActiveCampaign_functions
{


    /**
     * Get lists
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_lists(){
        
        try{
            $config_data = self::get_config_data();
            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
            $response = $client->request('GET', "{$config_data['url']}/api/3/lists?limit=100", [
                'headers' => [
                    'Accept'        => 'application/json',
                    'api-token'     => "{$config_data['token']}",
                    
                ],
            ]);

            if( 200 == $response->getStatusCode() ){
                $result = json_decode($response->getBody()->getContents());
                if( isset($result->lists) ){
                    if( is_array($result->lists) ){
                        $formatted_lists = [];
                        foreach( $result->lists as $list ){
                            if( $list->name ){
                                $formatted_lists[$list->id] = [
                                    'value' => $list->name 
                                ];
                            }
                        }
                        return $formatted_lists;
                    }
                }
            }

        }catch(GuzzleException $e){
            error_log(print_r($e,1));
            return [];
        }
        return [];
        
    }

    /**
     * Get active campaign tags
     * 
     * @return Array
     * @since 1.0.0
     */
    public static function get_tags(){
        try{
            $config_data = self::get_config_data();
            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
            $response = $client->request('GET', "{$config_data['url']}/api/3/tags?limit=100", [
                'headers' => [
                    'Accept'        => 'application/json',
                    'api-token'     => "{$config_data['token']}",
                    
                ],
            ]);

            if( 200 == $response->getStatusCode() ){
                $result = json_decode($response->getBody()->getContents());
                if( isset($result->tags) ){
                    if( is_array($result->tags) ){
                        $formatted_tags = [];
                        foreach( $result->tags as $tag ){
                            if( $tag->tag ){
                                $formatted_tags[$tag->id] = $tag->tag;
                            }
                        }
                        return $formatted_tags;
                    }
                }
            }

        }catch(GuzzleException $e){
            error_log(print_r($e,1));
            return [];
        }
        return [];
    } 


    /**
     * get config data
     * 
     * @return Array
     * @since 1.0.0
     * 
     */
    public static function get_config_data(){
        $creds = get_option( '_wpfnl_addons_cred' );
        $config_data = [
            'token' => '',
            'url'   => '',
        ];
        if( isset($creds['activecamp']) && isset($creds['activecamp']['active_camp_url']) && isset($creds['activecamp']['active_camp_api'])){

            $config_data['token'] = Wpfunnels_Aes_Ctr::decrypt( $creds['activecamp']['active_camp_api'], WPFNL_SECURITY_KEY, 256 );
            $config_data['url']   = $creds['activecamp']['active_camp_url'];
        
        }
        return $config_data;
    } 


    /**
     * maybe active campaign settings enable
     * 
     * @return Bool
     * @since 1.0.
     */
    public static function maybe_active_campaign_enable(){
        if( Wpfnl_Integartion_functions::is_pro_integrations_license_activated() ){
            $creds = get_option( '_wpfnl_addons_cred' );
            if( isset($creds['activecamp']) && isset($creds['activecamp']['status'])  && isset($creds['activecamp']['activecamp_status'])  && isset($creds['activecamp']['active_camp_url']) && isset($creds['activecamp']['active_camp_api'])){
                if( 'active' == $creds['activecamp']['activecamp_status'] && 'active' == $creds['activecamp']['status'] ){
                    return true;
                }
            }
        }
        return false;
    }


}