<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use GuzzleHttp\Exception\GuzzleException;
use WPFunnelsPro\Integartions\Zapier\Wpfnl_Integartion_Zapier_functions;


/**
 * integration class for Zapier
 *
 * Class Zapier
 */
class Zapier extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'Zapier';
    }

    /**
     * Retrieve user information from db
     * 
     * @param int $order_id
     * @param int $funnel_id
     * @param array $user_info
     * 
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];

        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }

        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     * 
     * @param int $order_id
     * @param array $user_info
     * 
     * @return array $user
     * 
     */
    private function get_user_info_for_woo( $order_id, $user_info = [] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();

                $items = $order->get_items();
                $main_order_product = array();
                
                foreach ( $items as $item ) {
                    $product_name = $item->get_name();
                    $product_price = $item->get_total();

                    $main_order_product[] = array(
                        "product_name" => $product_name,
                        "product_price" => $product_price
                    );
                }
                $user['ordered_products'] = $main_order_product;

                if( $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                }
                $user['billing_email']      = $order->get_billing_email();
                $user['billing_first_name'] = $order->get_billing_first_name();
                $user['billing_last_name']  = $order->get_billing_last_name();
                $user['billing_phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }

        }else{
            return $user_info;
        }
        return $user;
    }


    /**
     * Get user for woocommerce
     * 
     * @param array $user_info
     * 
     * @return array $user
     */
    private function get_user_info_for_lms( $user_info ){
        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Sending data to zapier
     * 
     * @param array $data
     * @return array
     */
    public function send_or_update_data( $data )
    {   
        if( $data ){
            if( is_array($data['tags']) && isset($data['tags']) && !empty($data['tags']) && isset($data['email']) && $data['email'] ){
                foreach( $data['tags'] as $key => $hook ){
                    try{
                        if( $hook ){
                            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                            $name = '';
							if( isset($data['first_name'],$data['last_name']) ){
								$name = $data['first_name'].' '.$data['last_name'];
							}elseif( isset($data['first_name'] ) ){
								$name = $data['first_name'].' '.$data['last_name'];
							}elseif( isset($data['last_name'] ) ){
								$name = $data['last_name'];
							}

                            $json_body_data = $this->get_formated_data( $data, $name );
                           
                            $response = $client->request('POST', $hook, [
                                'headers' => [
                                    'Content-Type'      => 'application/json',
                                    'Accept' => 'application/json'
                                ],
                                'body'   => $json_body_data
                            ]);

                            if( 200 == $response->getStatusCode() ){
                                $result = json_decode($response->getBody()->getContents());
                                return $result;
                            }

                        }

                    }catch (Exception $e) {
                        error_log(print_r($e->getMessage(),1));
                        echo $e->getMessage();
                    }catch (GuzzleException $e) {
                        error_log(print_r($e->getMessage(),1));
                        echo $e->getMessage();
                    }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                        error_log(print_r($e->getMessage(),1));
                        echo $e->getMessage();
                    }
                   
                }
            } 
        }
    }


    /**
     * Get formated data to send in Zapier
     * 
     * @param array $data
     * @param string $name
     * 
     * @return string
     */
    public function get_formated_data( $data, $name){
        $action = isset($data['source']) ? $data['source'] : '';

        $formatted_data = [
                            'ad_tracking'         => 'WPFunnels',
                            'email'               => isset($data['email']) ? $data['email'] : '',
                            'name'                => $name,
                            'phone_number'        => isset($data['phone']) ? $data['phone'] : '',
                            'billing_email'       => isset($data['billing_email']) ? $data['billing_email'] : '',
                            'billing_first_name'  => isset($data['billing_first_name']) ? $data['billing_first_name'] : '',
                            'billing_last_name'   => isset($data['billing_last_name']) ? $data['billing_last_name'] : '',
                            'billing_phone'       => isset($data['billing_phone']) ? $data['billing_phone'] : '',
                        ];

        if ( isset($data['ordered_products']) ){
            for ($idx = 1; $idx <= count($data['ordered_products']); $idx++){
                $formatted_data['product_name_'.$idx] = $data['ordered_products'][$idx-1]['product_name'];
                $formatted_data['product_price_'.$idx] = $data['ordered_products'][$idx-1]['product_price'];
            }
        }

        return json_encode($formatted_data); 
    }


    /**
     * Update contact with list
     * 
     * @param int $client
     * @param mixed $config_data
     * @param int $list_id
     * @param int $contact_id
     * 
     */
    public function update_contact_with_list( $client, $config_data, $list_id , $contacts_id ){

        $formatted_list_data = [
            'contactList' => [
                'list'      => $list_id,
                'contact'   => $contacts_id,
                'status'    => 1
            ]
        ];
        $json_body_list_data = json_encode($formatted_list_data);

        $update_list_response = $client->request('POST', "{$config_data['url']}/api/3/contactLists", [
            'body'    => $json_body_list_data,
            'headers' => [
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
                'api-token'     => "{$config_data['token']}",
                
            ],
        ]);
    }


    /**
     * Update contact with tags
     * @param int $client
     * @param mixed $config_data
     * @param int $list_id
     * @param int $contact_id
     * @since 1.0.0
     */
    private function update_contact_with_tag( $client, $config_data, $tag_id, $contact_id ){

        $formatted_tag_data = [
            'contactTag' => [
                'tag'       => $tag_id,
                'contact'   => $contact_id,
            ]
        ];

        $json_body_tag_data = json_encode($formatted_tag_data);
        $update_tag_response = $client->request('POST', "{$config_data['url']}/api/3/contactTags", [
            'body'    => $json_body_tag_data,
            'headers' => [
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
                'api-token'     => "{$config_data['token']}",
                
            ],
        ]);

    }

    /**
     * check if zapier is activated or not
     * 
     * @param int $id
     */
    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if zapier is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get Zapier webhook as lists
     * 
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_Zapier_functions::get_lists();
    }

    /**
     * Get Zapier tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return Wpfnl_Integartion_Zapier_functions::get_tags();
    }

}