<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WPFunnelsPro\Integartions\Mailpoet\Wpfnl_Integartion_Mailpoet_functions;


/**
 * integration class for Mailpoet
 *
 * Class Mailpoet
 */
class Wpfnl_Mailpoet extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'MailPoet';
    }

    /**
     * Retrieve user information from db
     * 
     * @param order_id
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_woo( $order_id, $user_info=[] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
    
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }
            
        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }

    

    /**
     * Sending data to Mailpoet to create or update contact, contact lists and tags
     * 
     * @param data
     * @return array
     */
    public function send_or_update_data( $data )
    {
        if( $data ){
            if( isset($data['email']) && $data['email'] && isset($data['lists']) && !empty($data['lists']) ){
                if (class_exists(\MailPoet\API\API::class)) {
                  
                    $subscriber_data = [];
                    if( $data['email'] ){
                        $subscriber_data['email'] = sanitize_text_field($data['email']);
                    }

                    if( isset($data['first_name']) && $data['first_name'] ){
                        $subscriber_data['first_name'] = sanitize_text_field($data['first_name']);
                    }

                    if( isset($data['last_name']) && $data['last_name'] ){
                        $subscriber_data['last_name'] = sanitize_text_field($data['last_name']);
                    }

                    $options = array(
                        'send_confirmation_email' => false 
                    );
            
                    // Check if subscriber exists
                    try {
                        $subscriber = \MailPoet\API\API::MP('v1')->getSubscriber($subscriber_data['email']);
                    } catch(\Exception $exception) {
                        // Subscriber does not yet exist, try to add subscriber
                        try {
                            $subscriber = \MailPoet\API\API::MP('v1')->addSubscriber($subscriber_data); // Add to default mailing list
                        } catch(\Exception $exception) {
                            error_log(print_r(json_encode($exception->getMessage()),1));
                        }
                    }

                    // Subscriber exists and needs to be added to certain lists
                    if (!empty($data['lists'])) {
                        $add_to_lists = array_map('intval', $data['lists']);
                        try {
                            $subscriber = \MailPoet\API\API::MP('v1')->subscribeToLists($subscriber_data['email'], $add_to_lists, $options);
                        } catch(\Exception $exception) {
                            error_log(print_r(json_encode($exception->getMessage()),1));
                        }
                    }

                }
            } 
        }
    }


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if Mailpoet is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get mailpoet lists
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_Mailpoet_functions::get_lists();
    }

    /**
     * Get mailpoet tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return [];
    }

}