<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Mailerlite\Wpfnl_Integartion_Mailerlite_functions;


/**
 * integration class for Mailerlite
 *
 * Class Mailerlite
 */
class Wpfnl_Mailerlite extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'Mailerlite';
    }

    /**
     * Retrieve user information from db
     * 
     * @param order_id
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_woo( $order_id, $user_info=[] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
    
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                }
            }
        }
        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }

    

    /**
     * Sending data to Mailerlite to create or update contact, contact lists and tags
     * 
     * @param data
     * @return array
     */
    public function send_or_update_data( $data )
    {
        if( $data ){
            if( isset($data['email']) && $data['email'] && isset($data['lists']) && !empty($data['lists']) ){
                foreach( $data['lists'] as $key => $list ){
                    if( isset($data['email'])){
                        try{
                            $creds = get_option( '_wpfnl_addons_cred' );
                            if( $creds && isset($creds['mailerlite']['mailerlite_api']) ){
                                $subscriber = [
                                    'email' => $data['email'],
                                    'name' => isset($data['first_name']) ? $data['first_name'] : '',
                                    'fields' => [
                                        'last_name' => isset($data['last_name']) ? $data['last_name'] : '',
                                    ],
                                    'type' => 'active'
                                ];
                                $json_body_data = json_encode($subscriber);
                                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                                $client->request('POST', 'https://api.mailerlite.com/api/v2/groups/'.$list.'/subscribers', [
                                    'headers' => [
                                        'Content-Type' => 'application/json',
                                        'X-MailerLite-ApiKey' => Wpfunnels_Aes_Ctr::decrypt( $creds['mailerlite']['mailerlite_api'], WPFNL_SECURITY_KEY, 256 ),
                                    ],
                                    'body' => $json_body_data
                                ]);
                            }
                        }catch( \Exception $e ){
                            error_log(print_r($e->getMessage(),1));
                        }
                    }
                }
            }
        }
    }


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if Mailerlite is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get Mailerlite group
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_Mailerlite_functions::get_lists();
    }

    /**
     * Get Mailerlite tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return [];
    }

}