<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WPFunnelsPro\Integartions\Mailchimp\Wpfnl_Integartion_Mailchimp_functions;


/**
 * integration class for mailchimp
 *
 * Class MailChimp
 */
class Wpfnl_MailChimp extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'MailChimp';
    }

    /**
     * Retrieve user information from db
     * 
     * @param order_id
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_woo( $order_id, $user_info=[]){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
    
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                    $user['address']    = $customer->get_billing_address_1() ? $customer->get_billing_address_1() : $customer->get_shipping_address_1();
                    $user['state']      = $customer->get_billing_state() ? $customer->get_billing_state() : $customer->get_shipping_state();
                    $user['city']       = $customer->get_billing_city() ? $customer->get_billing_city() : $customer->get_shipping_city();
                    $user['zip']        = $customer->get_billing_postcode() ? $customer->get_billing_postcode() : $customer->get_shipping_postcode();
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                    $user['address']    = $order->get_billing_address_1() ? strip_tags($order->get_billing_address_1()) : strip_tags($order->get_shipping_address_1());
                    $user['state']      = $order->get_billing_state() ? strip_tags($order->get_billing_state()) : strip_tags($order->get_shipping_state()); 
                    $user['city']       = $order->get_billing_city() ? strip_tags($order->get_billing_city()) : strip_tags($order->get_shipping_city()); 
                    $user['zip']        = $order->get_billing_postcode() ? strip_tags($order->get_billing_postcode()) : strip_tags($order->get_shipping_postcode()); 
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }
        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }
    


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Sending data to mailchimp to create or update contact, contact lists and tags
     * 
     * @param data
     * @return array
     */
    public function send_or_update_data( $data )
    { 
        if( $data ){
            if( !empty($data['lists']) ){
                foreach( $data['lists'] as $key => $list ){

                    if( $list ){
                        /** Get Mailchimp Obj */
                        $mailchimp = Wpfnl_Integartion_Mailchimp_functions::get_mailchimp_obj();

                        if( $mailchimp ){
                            /** get config data */
                            $config_data = Wpfnl_Integartion_Mailchimp_functions::get_config_data();
                            
                            if( $config_data ){
                                /** set config data */
                                $response = Wpfnl_Integartion_Mailchimp_functions::set_config_data( $config_data, $mailchimp );
                                if( $response ){

                                    /** Get tag and retive tag name by tag ID */
                                    $list_data['list_id'] = $list;
                                    $tags = Wpfnl_Integartion_Mailchimp_functions::get_mailchimp_tags($list_data);
                                    $tag_name = isset($tags[$data['tags'][$key]]) ? $tags[$data['tags'][$key]] : '';

                                    /** Make subcriber hash with user email */
                                    $subscriber_hash = isset($data['email']) && $data['email'] ? md5(strtolower($data['email'])) : '';

                                    /** Add/Update listMember as a subscriber by list ID and subscriber hash */
                                    
                                    $mailchimp->lists->setListMember($list_data['list_id'], $subscriber_hash, [
                                        "email_address" => isset($data['email']) && $data['email'] ? strtolower($data['email']) : '',
                                        "status_if_new" => "subscribed",
                                        "merge_fields"  => array(                
                                                'FNAME'   => isset($data['first_name']) ? $data['first_name'] : "",
                                                'LNAME'   => isset($data['last_name'])  ? $data['last_name'] : "",
                                                'PHONE'   => isset($data['phone'])  ? $data['phone'] : "",
                                                'ADDRESS' => [
                                                    "addr1"  => isset($data['address'])  ? $data['address'] : "No address",
                                                    "city"   => isset($data['city'])  ? $data['city'] : "No city",
                                                    "state"  => isset($data['state'])  ? $data['state'] : "No state",
                                                    "zip"    => isset($data['zip'])  ? $data['zip'] : "No zip"
                                                ]
                                        )
                                    ]);
                                    
                                    /** assign tag to subscriber */
                                    if( $tag_name ){
                                        $mailchimp->lists->updateListMemberTags($list_data['list_id'], $subscriber_hash, [
                                            "tags" => [["name" => $tag_name, "status" => "active"]],
                                        ]);
                                    }
                                }
                                
                            }
                            
                        }
                    }
                }
            } 
        }
    }


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if mailchimp is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get Mailchimp lists
     * 
     * @return array
     */
    public function get_crm_contact_lists(){

        try {
            $mailchimp = Wpfnl_Integartion_Mailchimp_functions::get_mailchimp_obj();
            $config_data = Wpfnl_Integartion_Mailchimp_functions::get_config_data();
            Wpfnl_Integartion_Mailchimp_functions::set_config_data( $config_data, $mailchimp );
            $response = Wpfnl_Integartion_Mailchimp_functions::get_lists( $mailchimp );
            return $response;
            
        }catch (\MailchimpMarketing\ApiException $e) {
              echo $e->getMessage();
        }
        return [];
    }

    /**
     * Get Mailchimp tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        try {
            return [];
            
        }catch (\MailchimpMarketing\ApiException $e) {
            return $e->getMessage();
        }
        return [];
    }

}