<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Hubspot\Wpfnl_Integartion_Hubspot_functions;


/**
 * integration class for mailchimp
 *
 * Class MailChimp
 */
class Wpfnl_Hubspot extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @return string
     * 
     * @since 1.2.0
     */
    public function get_name(){
        return 'Hubspot';
    }

    /**
     * Get user information from an order.
     *
     * @param int|null $order_id    Order ID (optional).
     * @param array    $user_info   Additional user information (optional).
     *
     * @return array User information array 
     * 
     * @since 1.2.0
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info);
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user information for WooCommerce order.
     *
     * @param int   $order_id   WooCommerce order ID.
     * @param array $user_info  Additional user information (optional).
     *
     * @return array User information array 
     * 
     * @since 1.2.0
     */
    private function get_user_info_for_woo( $order_id, $user_info = [] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
    
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }

        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
        return $user;
    }


    /**
     * Get user information for LMS.
     *
     * @param array $user_info User information array (optional).
     *
     * @return array User information array 
     * 
     * @return 1.2.0
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user information for lead.
     *
     * @param array $user_info User information array (optional).
     *
     * @return array User information array 
     * @since 1.2.0
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }

    /**
     * Send or update data to HubSpot.
     *
     * @since 1.2.0
     *
     * @param array $data The data to send or update.
     *
     * @return void|bool
     */
    public function send_or_update_data( $data )
    {
        if ( !$data ){
            return false;
        }
        if( isset($data['lists']) && !empty($data['lists']) && isset($data['email']) && $data['email'] ){
            foreach( $data['lists'] as $key => $list ){
                try{
                    if( isset($data['email'])){
                        $url = Wpfnl_Integartion_Hubspot_functions::hubspot_authentication_url();
                        $creds = get_option( '_wpfnl_addons_cred' );
                        if( $creds && isset($creds['hubspot'],$creds['hubspot']['hubspot_status'],$creds['hubspot']['hubspot_api'],$creds['hubspot']['status']) && 'active' === $creds['hubspot']['hubspot_status'] && 'active' === $creds['hubspot']['status']  ){
                            $email     = $data['email'];
                            $firstName = isset($data['first_name']) ? $data['first_name'] : '';
                            $lastName  = isset($data['last_name']) ? $data['last_name'] : '';
                            $phone     = isset($data['phone']) ? $data['phone'] : '';

                            $formatted_data = array(
                                'properties' => array(
                                    array(
                                        'property' => 'email',
                                        'value' => $email
                                    ),
                                    array(
                                        'property' => 'firstname',
                                        'value' => $firstName
                                    ),
                                    array(
                                        'property' => 'lastname',
                                        'value' => $lastName
                                    ),
                                    array(
                                        'property' => 'phone',
                                        'value' => $phone
                                    )
                                )
                            );
                            
                            $json_body_data = json_encode($formatted_data);
                            $response = wp_remote_request($url.'contacts/v1/contact/', array(
                                'method' => 'POST',
                                'headers' => array(
                                    'Authorization' => 'Bearer ' .  Wpfunnels_Aes_Ctr::decrypt( $creds['hubspot']['hubspot_api'], WPFNL_SECURITY_KEY, 256 ),
                                    'Content-Type' => 'application/json',
                                ),
                                'body' => $json_body_data,
                            ));

                            if (is_wp_error( $response )){
                                $error_message = $response->get_error_message();
                                error_log(print_r($error_message,1));
                            }

                            if( 200 === wp_remote_retrieve_response_code($response) ){
                                $result = json_decode(wp_remote_retrieve_body($response));
                                $user_id = '';
                                if( !empty($result->vid) ){
                                    $user_id = $result->vid;
                                }
                                
                                if( $user_id ){
                                    $add_list_data = array(
                                        'vids' => array( $user_id ),
                                        'emails' => array( $email )
                                    );

                                    $json_list_data = json_encode($add_list_data);

                                    $response = wp_remote_request($url.'contacts/v1/lists/'.$list.'/add', array(
                                        'method' => 'POST',
                                        'headers' => array(
                                            'Authorization' => 'Bearer ' .  Wpfunnels_Aes_Ctr::decrypt( $creds['hubspot']['hubspot_api'], WPFNL_SECURITY_KEY, 256 ),
                                            'Content-Type' => 'application/json',
                                        ),
                                        'body' => $json_list_data,
                                    ));

                                    $result = json_decode(wp_remote_retrieve_body($response));

                                    if (is_wp_error( $response )){
                                        $error_message = $response->get_error_message();
                                        error_log(print_r($error_message,1));
                                    }
                                }
                            }
                        }
                    }
                }catch (\Exception $e) {
                    error_log(print_r($e->getMessage(),1));
                }
            }
        } 
    }


    /**
     * Update contact with a specific list.
     *
     * @param Client $client The GuzzleHttp client.
     * @param array  $config_data Configuration data for the contact update.
     * @param int    $list_id The ID of the list to associate the contact with.
     * @param int    $contact_id The ID of the contact to update.
     *
     * @return void
     * @since 1.2.0
     */
    public function update_contact_with_list( $client, $config_data, $list_id , $contacts_id ){
        // TODO: Update list with contact
    }


    /**
     * Update contact with tags
     * 
     * @param Client $client The GuzzleHttp client.
     * @param array  $config_data Configuration data for the contact update.
     * @param int    $list_id The ID of the list to associate the contact with.
     * @param int    $contact_id The ID of the contact to update.
     * 
     * @return void
     * 
     * @since 1.2.0
     */
    private function update_contact_with_tag( $client, $config_data, $tag_id, $contact_id ){
        // TODO: No tag for hubspot
    }

     /**
     * Check if hubspot is activated or not
     *
     * @return int $id 
     * 
     * @since 1.2.0
     */
    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * Check if hubspot is activated or not
     *
     * @return bool
     * @since 1.2.0
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get Hubspot lists
     * 
     * @return array
     * @since 1.2.0
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_Hubspot_functions::get_lists();
    }

    /**
     * Get Hubspot tags
     * 
     * @param array $list
     * @return array
     * 
     * @since 1.2.0
     */
    public function get_crm_contact_tags( $list = [] ){
        return Wpfnl_Integartion_Hubspot_functions::get_tags();
    }

}