<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use GuzzleHttp\Exception\GuzzleException;
use WPFunnelsPro\Integartions\GetResponse\Wpfnl_Integartion_GetResponse_functions;


/**
 * integration class for mailchimp
 *
 * Class MailChimp
 */
class Wpfnl_GetResponse extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'GetResponse';
    }

    /**
     * Retrieve user information from db
     * 
     * @param order_id
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_woo( $order_id, $user_info=[] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }

        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
       
        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }

    /**
     * Sending data to constant contact to create or update contact, contact lists and tags
     * 
     * @param data
     * @return array
     */
    public function send_or_update_data( $data )
    {   
        if( $data ){
            if( isset($data['lists']) && !empty($data['lists']) && isset($data['email']) && $data['email'] ){
                foreach( $data['lists'] as $key => $list ){
                    try{
                        if( isset($data['email'])){
                            $url = Wpfnl_Integartion_GetResponse_functions::getresponse_authentication_url();
                            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                            $creds = get_option( '_wpfnl_addons_cred' );
                            if( $creds && isset($creds['getresponse'],$creds['getresponse']['getresponse_status'],$creds['getresponse']['getresponse_api'],$creds['getresponse']['status']) && 'active' === $creds['getresponse']['getresponse_status'] && 'active' === $creds['getresponse']['status']  ){
                                
                                $response = $client->request('GET', $url."campaigns/".$list."/contacts", [
                                    'headers' => [
                                        'Content-Type'      => 'application/json',
                                        'X-Auth-Token'      => 'api-key '. Wpfunnels_Aes_Ctr::decrypt( $creds['getresponse']['getresponse_api'], WPFNL_SECURITY_KEY, 256 ),
                                    ],
                                ]);
                                
                                $firstName         = isset($data['first_name']) ? $data['first_name'] : '';
                                $lastName          = isset($data['last_name']) ? $data['last_name'] : '';
                                if( !$firstName && !$lastName ){
                                    $name = $name = strstr($data['email'],'@',true);;
                                }

                                $tag_id            = isset($data['tags'][0]) ? $data['tags'][0] : '';
                                $formatted_data = [
                                    'email'         => isset($data['email']) ? $data['email'] : '',
                                    'name'          => $name,
                                    'tags'          => [
                                        [
                                            "tagId" =>  $tag_id
                                        ]
                                    ],
                                    "campaign"      => [
                                        "campaignId" => $list
                                    ]
                                ];
                                
                                $json_body_data = json_encode($formatted_data);
                                if( 200 == $response->getStatusCode() ){
                                    $result = json_decode($response->getBody()->getContents());
                                    $is_contact_exists = false;
                                    $contactId = '';
                                    if( is_array($result) && !empty($result) ){
                                        
                                        foreach( $result as $contact ){
                                            
                                            if( !empty($contact->campaign->campaignId) && !empty($contact->email) && $data['email'] == $contact->email && $list == $contact->campaign->campaignId  ){
                                                
                                                $is_contact_exists = true;
                                                $contactId = $contact->contactId;
                                            }
                                        }
                                    }
                                    
                                    if( $is_contact_exists ){
                                        try{
                                            $response = $client->request('POST', $url."contacts/".$contactId, [
                                                'body'    => $json_body_data,
                                                'headers' => [
                                                    'Content-Type'      => 'application/json',
                                                    'X-Auth-Token'      => 'api-key '. Wpfunnels_Aes_Ctr::decrypt( $creds['getresponse']['getresponse_api'], WPFNL_SECURITY_KEY, 256 ),
                                                ],
                                            ]);
                                            
                                            
                                        }catch (\Exception $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }catch (GuzzleException $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }
                                    }else{
                                        try{
                                            $response = $client->request('POST', $url."contacts", [
                                                'body'    => $json_body_data,
                                                'headers' => [
                                                    'Content-Type'      => 'application/json',
                                                    'X-Auth-Token'      => 'api-key '. Wpfunnels_Aes_Ctr::decrypt( $creds['getresponse']['getresponse_api'], WPFNL_SECURITY_KEY, 256 ),
                                                ],
                                            ]);
                                        }catch (\Exception $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }catch (GuzzleException $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }    
                                    }  
                                }
                            }
                        }
                        
                        
                    }catch (\Exception $e) {
                        error_log(print_r($e->getMessage(),1));
                    }catch (GuzzleException $e) {
                        error_log(print_r($e->getMessage(),1));
                    }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                        error_log(print_r($e->getMessage(),1));
                    }
                   
                }
            } 
        }
    }


    


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if mailchimp is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get GetResponse lists
     * 
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_GetResponse_functions::get_lists();
    }

    /**
     * Get GetResponse tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return Wpfnl_Integartion_GetResponse_functions::get_tags();
    }

}