<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use GuzzleHttp\Exception\GuzzleException;
use WPFunnelsPro\Integartions\Encharge\Wpfnl_Integartion_Encharge_functions;


/**
 * integration class for Encharge
 *
 * Class Encharge
 */
class Wpfnl_Encharge extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'Encharge';
    }


    /**
     * Retrieve user information
     * 
     * @param Object $order_id
     * @param Integer $funnel_id
     * @param Array $user_info
     * @return array 
     * 
     * @since 1.0.12
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     * @param Object $order_id
     * @return Array $user
     * @since 1.0.12
     */
    private function get_user_info_for_woo( $order_id, $user_info=[] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }

        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
       
        return $user;
    }


    /**
     * Get user for LMS
     * @param Array $user_info
     * @return Array $user_info
     * @since 1.0.12
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user for lead gen
     * 
     * @param Array
     * @return Array
     * @since 1.0.12
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }

    /**
     * Sending data to Encharge to create or update contact, assign contact to tag
     * 
     * @param Array data
     * @return void
     * @since 1.0.12
     */
    public function send_or_update_data( $data )
    {   
        if( $data ){
            if( isset($data['tags']) && !empty($data['tags']) && isset($data['email']) && $data['email'] ){
                foreach( $data['tags'] as $key => $tag ){
                    try{
                        if( isset($data['email'])){
                            $url = Wpfnl_Integartion_Encharge_functions::encharge_authentication_url();
                            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                            $creds = get_option( '_wpfnl_addons_cred' );
                            if( $creds && isset($creds['encharge'],$creds['encharge']['encharge_status'],$creds['encharge']['encharge_api'],$creds['encharge']['status']) && 'active' === $creds['encharge']['encharge_status'] && 'active' === $creds['encharge']['status']  ){
                                
                                error_log(print_r($data,1));
                                
                                $firstName         = isset($data['first_name']) ? $data['first_name'] : '';
                                $lastName          = isset($data['last_name']) ? $data['last_name'] : '';
                                $phone          = isset($data['phone']) ? $data['phone'] : '';
                                $name = '';

                                if( !$firstName && !$lastName ){
                                   $name = strstr($data['email'],'@',true);;
                                }

                                $formatted_data = [
                                    'email'         => isset($data['email']) ? $data['email'] : '',
                                    'name'          => $name,
                                    'firstName'     => $firstName,
                                    'lastName'      => $lastName,
                                    'phone'         => $phone,
                                ];
                                
                                $json_body_data = json_encode($formatted_data);
                                $response = $client->request('POST', $url."people", [
                                    'body'    => $json_body_data,
                                    'headers' => [
                                        'Content-Type'      => 'application/json',
                                        'X-Encharge-Token'  => Wpfunnels_Aes_Ctr::decrypt( $creds['encharge']['encharge_api'], WPFNL_SECURITY_KEY, 256 ),
                                    ],
                                ]);

                                if( 200 == $response->getStatusCode() ){
                                    $result = json_decode($response->getBody()->getContents());
                                    $user_id = '';
                                    if( !empty($result->users) ){
                                        foreach( $result->users as $user ){
                                            
                                            if( !empty($user->id) ){
                                                $user_id = $user->id;
                                            }
                                        }
                                    }
                                    
                                    if( $user_id ){
                                        try{
                                            $tag_data = [
                                                'tag'   => $tag,
                                                'id'    => $user_id,
                                                'email' => $data['email']
                                            ];
                                            $json_tag_data = json_encode($tag_data);

                                            $response = $client->request('POST', $url."tags", [
                                                'body'    => $json_tag_data,
                                                'headers' => [
                                                    'Content-Type'      => 'application/json',
                                                    'X-Encharge-Token'  => Wpfunnels_Aes_Ctr::decrypt( $creds['encharge']['encharge_api'], WPFNL_SECURITY_KEY, 256 ),
                                                ],
                                            ]);
                                            
                                            
                                        }catch (\Exception $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }catch (GuzzleException $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                                            error_log(print_r($e->getMessage(),1));
                                        }
                                    }
                                }
                            }
                        }
                        
                        
                    }catch (\Exception $e) {
                        error_log(print_r($e->getMessage(),1));
                    }catch (GuzzleException $e) {
                        error_log(print_r($e->getMessage(),1));
                    }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                        error_log(print_r($e->getMessage(),1));
                    }
                   
                }
            } 
        }
    }


    


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if mailchimp is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get encharge lists
     * 
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_Encharge_functions::get_lists();
    }

    /**
     * Get encharge tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return Wpfnl_Integartion_Encharge_functions::get_tags();
    }

}