<?php

namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use GuzzleHttp\Exception\GuzzleException;
use WPFunnelsPro\Integartions\Aweber\Wpfnl_Integartion_Aweber_functions;


/**
 * integration class for mailchimp
 *
 * Class MailChimp
 */
class Wpfnl_Aweber extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'Aweber';
    }

    /**
     * Retrieve user information from db
     * 
     * @param order_id
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }

        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_woo( $order_id, $user_info = [] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
    
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }

        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Sending data to mailchimp to create or update contact, contact lists and tags
     * 
     * @param data
     * @return array
     */
    public function send_or_update_data( $data )
    {
        if( $data ){
            if( isset($data['lists']) && !empty($data['lists']) && isset($data['email']) && $data['email'] ){
                foreach( $data['lists'] as $key => $list ){
                    try{
                        
                        $creds = get_option( '_wpfnl_addons_cred' );
                        $token = '';
                        if( $creds && isset($creds['aweber']) && isset($creds['aweber']['aweber_token']) && isset($creds['aweber']['aweber_refresh_token']) ){
                            Wpfnl_Integartion_Aweber_functions::get_token_by_refresh_token();
                            $creds = get_option( '_wpfnl_addons_cred' );
                            $token = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_token'], get_option('_wpfnl_security_key'), 256 );
                        
                        }else{
                            Wpfnl_Integartion_Aweber_functions::get_access_token();
                            $creds = get_option( '_wpfnl_addons_cred' );
                            if( $creds && isset($creds['aweber']) && isset($creds['aweber']['aweber_token']) ){
                                $token = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_token'], get_option('_wpfnl_security_key'), 256 );
                            }
                        }

                        if( $token ){
                            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                            $account_id = Wpfnl_Integartion_Aweber_functions::get_account( $client, $token );
                            $name = '';
							if( isset($data['first_name'],$data['last_name']) ){
								$name = $data['first_name'].' '.$data['last_name'];
							}elseif( isset($data['first_name'] ) ){
								$name = $data['first_name'].' '.$data['last_name'];
							}elseif( isset($data['last_name'] ) ){
								$name = $data['last_name'];
							}

                            $formatted_data = [
                                'ad_tracking'       => 'WPFunnels',
                                'email'             => isset($data['email']) ? $data['email'] : '',
                                'name'              => $name,
                                'phone_number'      => isset($data['phone']) ? $data['phone'] : '',
                                'update_existing'   => 'true',
                                'tags'              => [ $data['tags'][$key] ]
                            ];
                            $json_body_data = json_encode($formatted_data);
                           
                            $response = $client->request('POST', "https://api.aweber.com/1.0/accounts/".$account_id."/lists/".$list."/subscribers", [
                                'headers' => [
                                    'Content-Type'      => 'application/json',
                                    'Authorization'     => 'Bearer '.$token,
                                    'Accept' => 'application/json',
                                    'User-Agent'        => 'AWeber-PHP-code-sample/1.0'
                                ],
                                'body'   => $json_body_data
                            ]);

                            if( 200 == $response->getStatusCode() ){
                                $result = json_decode($response->getBody()->getContents());
                                
                            }
                        }

                    }catch (Exception $e) {
                        error_log(print_r($e->getMessage(),1));
                        echo $e->getMessage();
                    }catch (GuzzleException $e) {
                        error_log(print_r($e->getMessage(),1));
                        echo $e->getMessage();
                    }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                        error_log(print_r($e->getMessage(),1));
                        echo $e->getMessage();
                    }
                   
                }
            } 
        }
    }


    /**
     * Update contact with list
     * 
     * @since 
     */
    public function update_contact_with_list( $client, $config_data, $list_id , $contacts_id ){

        $formatted_list_data = [
            'contactList' => [
                'list'      => $list_id,
                'contact'   => $contacts_id,
                'status'    => 1
            ]
        ];
        $json_body_list_data = json_encode($formatted_list_data);

        $update_list_response = $client->request('POST', "{$config_data['url']}/api/3/contactLists", [
            'body'    => $json_body_list_data,
            'headers' => [
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
                'api-token'     => "{$config_data['token']}",
                
            ],
        ]);
    }


    /**
     * Update contact with tags
     * 
     * @since 1.0.0
     */
    private function update_contact_with_tag( $client, $config_data, $tag_id, $contact_id ){

        $formatted_tag_data = [
            'contactTag' => [
                'tag'       => $tag_id,
                'contact'   => $contact_id,
            ]
        ];

        $json_body_tag_data = json_encode($formatted_tag_data);
        $update_tag_response = $client->request('POST', "{$config_data['url']}/api/3/contactTags", [
            'body'    => $json_body_tag_data,
            'headers' => [
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
                'api-token'     => "{$config_data['token']}",
                
            ],
        ]);

    }


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if mailchimp is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get Mailchimp lists
     * 
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_Aweber_functions::get_lists();
    }

    /**
     * Get Mailchimp tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return Wpfnl_Integartion_Aweber_functions::get_tags();
    }

}