<?php
namespace WPFunnelsPro\Integrations;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use WPFunnelsPro\Integrations\CRM;
use WPFunnelsPro\Integartions\ActiveCampaign\Wpfnl_Integartion_ActiveCampaign_functions;


/**
 * integration class for mailchimp
 *
 * Class MailChimp
 */
class Wpfnl_ActiveCampaign extends CRM {

    use SingletonTrait;

    /**
     * Get CRM Name
     * 
     * @param null
     * @return string
     */
    public function get_name(){
        return 'ActiveCampaign';
    }

    /**
     * Retrieve user information from db
     * 
     * @param order_id
     * @return array
     */
    public function get_user_info_from_order( $order_id = null, $user_info = [] ) {
        
        $user = [];
        $funnel_id = Wpfnl_functions::get_funnel_id_from_order( $order_id );
        
        if( $funnel_id ){
            $type = get_post_meta( $funnel_id, '_wpfnl_funnel_type', true );
           
            if( 'lms' === $type ){
                $user = $this->get_user_info_for_lms( $user_info );
            }elseif( 'wc' === $type ){
                $user = $this->get_user_info_for_woo( $order_id, $user_info );
            }elseif( 'lead' === $type ){
                $user = $this->get_user_info_for_lead( $user_info );
            }
        }else{
            $user = $this->get_user_info_for_woo( $order_id, $user_info );
        }
        $user['status']     = 'pending';

        return $user;
    }


    /**
     * Get user for woocommerce
     */
    private function get_user_info_for_woo( $order_id, $user_info=[] ){
        $user = [];
        if( $order_id ){
            $order              = wc_get_order( $order_id );
            if( $order ){
                $customer_id        = $order->get_customer_id();
                $user               = array();
    
                if( 0 != $customer_id ) {
                    $customer           = new \WC_Customer( $customer_id );
                    $user['email']      = $customer->get_email();
                    $user['first_name'] = $customer->get_first_name();
                    $user['last_name']  = $customer->get_last_name();
                    $user['phone']      = get_user_meta( $customer_id, 'billing_phone', true ) ? get_user_meta( $customer_id, 'billing_phone', true ) : '';
                } else {
                    $user['email']      = $order->get_billing_email();
                    $user['first_name'] = $order->get_billing_first_name();
                    $user['last_name']  = $order->get_billing_last_name();
                    $user['phone']      = $order->get_billing_phone() ? $order->get_billing_phone() : '';
                }
            }else{
                $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
                $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
                $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
            }
            
        }else{
            $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
            $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
            $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        }
        return $user;
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * 
     * @return Array
     */
    private function get_user_info_for_lms( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Get user for woocommerce
     * 
     * @param Array
     * @return Array
     */
    private function get_user_info_for_lead( $user_info ){

        $user = [];
        $user['email']       = isset($user_info['email']) ? $user_info['email'] : '';
        $user['first_name']  = isset($user_info['first_name']) ? $user_info['first_name'] : '';
        $user['last_name']   = isset($user_info['last_name']) ? $user_info['last_name'] : '';
        return $user;
        
    }


    /**
     * Sending data to mailchimp to create or update contact, contact lists and tags
     * 
     * @param data
     * @return array
     */
    public function send_or_update_data( $data )
    {
        if( $data ){
            if( isset($data['lists']) && !empty($data['lists']) && isset($data['email']) && $data['email'] ){
                foreach( $data['lists'] as $key => $list ){
                    $config_data = Wpfnl_Integartion_ActiveCampaign_functions::get_config_data();
                    if( isset($config_data['url']) && isset($config_data['token']) ){
                        try{

                            $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                            $get_response = $client->request('GET', "{$config_data['url']}/api/3/contacts?email=".$data['email'], [
                                'headers' => [
                                    'Accept'        => 'application/json',
                                    'api-token'     => "{$config_data['token']}",
                                    
                                ],
                            ]);
                            if( 200 == $get_response->getStatusCode() ){
                                $contacts = $get_response->getBody()->getContents();
                                $contacts = json_decode($contacts);
                                if( isset($contacts->contacts) && is_array($contacts->contacts) ){
                                    $is_exists = false;
                                    foreach( $contacts->contacts as $contact ){
                                        if( $data['email'] == $contact->email ){
                                            $is_exists = true;
                                            $this->update_contact_with_list($client, $config_data, $list, $contact->id);
                                            $tag_id = isset($data['tags'][0]) ? $data['tags'][0] : '';
                                            $this->update_contact_with_tag($client, $config_data, $tag_id, $contact->id);
                                            
                                        }
                                    }
                                    if( !$is_exists ){
                                        $formatted_data = [
                                            'contact' => [
                                                'email'         => isset($data['email']) ? $data['email'] : '',
                                                'firstName'     => isset($data['first_name']) ? $data['first_name'] : '',
                                                'lastName'      => isset($data['last_name']) ? $data['last_name'] : '',
                                                'phone'         => isset($data['phone']) ? $data['phone'] : '',
                                                'fieldValues'   => []
                                            ]
                                        ];

                                        $json_body_data = json_encode($formatted_data);
                                        $response = $client->request('POST', "{$config_data['url']}/api/3/contacts", [
                                            'body'    => $json_body_data,
                                            'headers' => [
                                                'Accept'        => 'application/json',
                                                'Content-Type'  => 'application/json',
                                                'api-token'     => "{$config_data['token']}",
                                                
                                            ],
                                        ]);

                                        if( 201 == $response->getStatusCode() ){
                                            $new_contact_response = json_decode($response->getBody()->getContents());
                                            if( isset($new_contact_response->contact) && isset($new_contact_response->contact->id) ){
                                                $this->update_contact_with_list($client, $config_data, $list, $new_contact_response->contact->id);
                                                $tag_id = isset($data['tags'][0]) ? $data['tags'][0] : '';
                                                $this->update_contact_with_tag($client, $config_data, $tag_id, $new_contact_response->contact->id);
                                            }
                                        }
                                    }
                                }
                            }

                            
                
                        }catch(GuzzleException $e){
                            error_log(print_r($e,1));
                            return [];
                        }
                    }
                }
            } 
        }
    }


    /**
     * Update contact with list
     * 
     * @since 
     */
    public function update_contact_with_list( $client, $config_data, $list_id , $contacts_id ){

        $formatted_list_data = [
            'contactList' => [
                'list'      => $list_id,
                'contact'   => $contacts_id,
                'status'    => 1
            ]
        ];
        $json_body_list_data = json_encode($formatted_list_data);

        $update_list_response = $client->request('POST', "{$config_data['url']}/api/3/contactLists", [
            'body'    => $json_body_list_data,
            'headers' => [
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
                'api-token'     => "{$config_data['token']}",
                
            ],
        ]);
    }


    /**
     * Update contact with tags
     * 
     * @since 1.0.0
     */
    private function update_contact_with_tag( $client, $config_data, $tag_id, $contact_id ){

        $formatted_tag_data = [
            'contactTag' => [
                'tag'       => $tag_id,
                'contact'   => $contact_id,
            ]
        ];

        $json_body_tag_data = json_encode($formatted_tag_data);
        $update_tag_response = $client->request('POST', "{$config_data['url']}/api/3/contactTags", [
            'body'    => $json_body_tag_data,
            'headers' => [
                'Accept'        => 'application/json',
                'Content-Type'  => 'application/json',
                'api-token'     => "{$config_data['token']}",
                
            ],
        ]);

    }


    public function deleteData($id)
    {
        // TODO: Implement deleteData() method.
    }

    /**
     * check if mailchimp is activated or not
     *
     * @return bool
     */
    function is_connected()
    {
       return true;
    }

    /**
     * Get Mailchimp lists
     * 
     * @return array
     */
    public function get_crm_contact_lists(){
        return Wpfnl_Integartion_ActiveCampaign_functions::get_lists();
    }

    /**
     * Get Mailchimp tags
     * 
     * @param null
     * @return array
     */
    public function get_crm_contact_tags( $list = [] ){
        return Wpfnl_Integartion_ActiveCampaign_functions::get_tags();
    }

}