<?php

namespace WPFunnelsPro\Integrations\CRM;
use WPFunnels\Traits\SingletonTrait;
use WPFunnelsPro\Wpfnl_Pro_functions;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * class for Automation rules
 *
 * Class AutomationRules
 * @package WPFunnelsPro\Integrations
 * @version 2.0.0
 */
class Automation {

    use SingletonTrait;

    /**
     * @var $name
     */
    protected $name;


    /**
     * @var $crm_name
     */
    protected $crm_name;


    /**
     * @var $crm
     */
    protected $crm;


    /**
     * @var $rules
     */
    protected $triggers;


    /**
     * @var $integrations
     */
    protected $integrations;


    /**
     * @var $data
     */
    protected $data;


    public function __construct( $automation, $data ) {
        $this->name         = $automation['name'];
        $this->triggers     = $automation['triggers'];
        $this->crm_name     = $automation['crm'];
        $this->data         = $data;
        $this->integrations = Wpfnl_Pro_functions::get_supported_crm();
        $this->crm          = $this->get_crm( $this->crm_name );
    }


    /**
     * Get CRM Object
     *
     * @param $crm_name
     * @return object
     */
    private function get_crm( $crm_name ) {
        $crm_class   = "WPFunnelsPro\\Integrations\\".$this->integrations[$crm_name]['class_name'];
        if (class_exists($crm_class)) {
            return $crm_class::getInstance();
        }
        return false;
    }

    /**
     * Initialize and triggers Automation Integration Process
     *
     * @param null
     * @return void
     */
    public function process_triggers() {
        if( $this->triggers ) {
            foreach ( $this->triggers as $trigger ) {
                if( !empty($trigger) && $this->crm ){
                    $trigger_object     = new TriggerObject( $trigger[0] );
                    $trigger_handler    = TriggerHandler::getInstance();
                    $trigger_handler->init( $trigger_object, $this->data, $this->crm );
                    $trigger_handler->start();
                }
            }
        }
    }
}