<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://getwpfunnels.com/
 * @since      1.0.0
 *
 * @package    Wpfunnels_Pro_Integrations
 * @subpackage Wpfunnels_Pro_Integrations/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Wpfunnels_Pro_Integrations
 * @subpackage Wpfunnels_Pro_Integrations/includes
 * @author     WPFunnels Team <support@getwpfunnels.com>
 */


use WPFunnelsPro\Integrations\Wpfunnels_Integrations_Ajax;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use WPFunnelsPro\Integartions\Aweber\Wpfnl_Integartion_Aweber_functions;
use WPFunnelsPro\Integartions\ConstantContact\Wpfnl_Integartion_ConstantContact_functions;
use WPFunnelsPro\Integartions\GetResponse\Wpfnl_Integartion_GetResponse_functions;
use WPFunnelsPro\Integrations\CRM\CrmIntegrations;

class Wpfunnels_Pro_Integrations {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Wpfunnels_Pro_Integrations_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * Crm integration class define.
	 *
	 * @since    1.0.17
	 * @access   protected
	 * @var      string    $crm_integrations 
	 */
	protected $crm_integrations;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'WPFNL_PRO_INTEGRATIONS_VERSION' ) ) {
			$this->version = WPFNL_PRO_INTEGRATIONS_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'wpfunnels-pro-integrations';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		$this->update_cc_creds();
		add_action( 'plugins_loaded', array( $this, 'init' ), 100 );
	}

	/**
     * Initialize the core of the plugin
     *
     * @since 1.0.0
     */
    public function init()
    {
		if( defined('WPFNL_VERSION') &&  defined('WPFNL_PRO_VERSION') ){
			$this->crm_integrations = CrmIntegrations::getInstance();
		}
    }

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Wpfunnels_Pro_Integrations_Loader. Orchestrates the hooks of the plugin.
	 * - Wpfunnels_Pro_Integrations_i18n. Defines internationalization functionality.
	 * - Wpfunnels_Pro_Integrations_Admin. Defines all hooks for the admin area.
	 * - Wpfunnels_Pro_Integrations_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
         * The class responsible for auto loading all files of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'vendor/autoload.php';

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/utils/class-wpfunnels-pro-integrations-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/utils/class-wpfunnels-pro-integrations-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-wpfunnels-pro-integrations-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-wpfunnels-pro-integrations-public.php';

		/**
          * Require action scheduler for crm
          */
         require_once plugin_dir_path(dirname(__FILE__)) . 'packages/action-scheduler/action-scheduler.php';


		$this->loader = new Wpfunnels_Pro_Integrations_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Wpfunnels_Pro_Integrations_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Wpfunnels_Pro_Integrations_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Wpfunnels_Pro_Integrations_Admin( $this->get_plugin_name(), $this->get_version() );
        $plugin_ajax = new Wpfunnels_Integrations_Ajax();
		
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'wpfunnels/add_submenu', $plugin_admin, 'register_addons_sub_menus' );
		$this->loader->add_action( 'wpfunnels/supported_crm_integrations', $plugin_admin, 'update_supported_crm' );
		$this->loader->add_filter( 'wpfunnels/addon-lists', $plugin_admin , 'register_addon_for_licensing', 10, 1 );
		$this->loader->add_filter( 'wpfnl_dashboard_nav_lists', $plugin_admin , 'add_dashboard_nav_lists', 10, 1 );
		$this->loader->add_filter( 'wpfunnels_constant_contact_authentication', $plugin_ajax , 'wpfunnels_constant_contact_authentication' );
		$this->loader->add_filter( 'wpfunnels/check_update_transient', $plugin_admin , 'check_update_transient' );
		$this->loader->add_filter( 'admin_head', $plugin_admin , 'hide_update_notice_from_integration_page' );
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Wpfunnels_Pro_Integrations_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Wpfunnels_Pro_Integrations_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

	/**
	 * Update constant conatct credentials after authentication
	 * 
	 * @since 1.0.3
	 */
	public function update_cc_creds(){
		if( isset($_GET['page']) && 'wpfunnels_integrations' === $_GET['page'] && isset($_GET['code']) && isset($_GET['state']) && $_GET['code'] && $_GET['state']){
			$creds = get_option( '_wpfnl_addons_cred' );
			if( $creds ){
				$check_string = '/wp-admin/admin.php?code';
				if(strpos($_SERVER['REQUEST_URI'], $check_string ) !== false){
					if( isset($creds['aweber']) ){
						$creds['aweber']['aweber_code']   	= Wpfunnels_Aes_Ctr::encrypt( $_GET['code'],  get_option('_wpfnl_security_key'), 256 );
						$creds['aweber']['aweber_state']   = Wpfunnels_Aes_Ctr::encrypt( $_GET['state'], get_option('_wpfnl_security_key'), 256 );
						update_option( '_wpfnl_addons_cred', $creds );
						$is_authorized = Wpfnl_Integartion_Aweber_functions::get_access_token();
						$creds = get_option( '_wpfnl_addons_cred' );
						$creds['aweber']['aweber_status'] 	= $is_authorized ? 'active' : 'deactive';
						update_option( '_wpfnl_addons_cred', $creds );
						
					}
				}else{
					if( isset($creds['cc']) ){
						$creds['cc']['cc_code']   	= Wpfunnels_Aes_Ctr::encrypt( $_GET['code'],  get_option('_wpfnl_security_key'), 256 );
						$creds['cc']['cc_state']   = Wpfunnels_Aes_Ctr::encrypt( $_GET['state'], get_option('_wpfnl_security_key'), 256 );
						update_option( '_wpfnl_addons_cred', $creds );
						
						$is_authorized = Wpfnl_Integartion_ConstantContact_functions::get_access_token();
						$creds = get_option( '_wpfnl_addons_cred' );
						$creds['cc']['cc_status'] 	= $is_authorized ? 'active' : 'deactive';
						update_option( '_wpfnl_addons_cred', $creds );
						
					}
				}
			}
		}
	}



	public function get_authorization_url( $clientId, $redirectURI, $state ) {
		// Create authorization URL
		$baseURL = "https://authz.constantcontact.com/oauth2/default/v1/authorize";
		$authURL = $baseURL . "?client_id=" . $clientId . "&state=235o250eddsdff&redirect_uri=" . $redirectURI . "&response_type=code";
	
		return $authURL;
	
	}

}
