<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://getwpfunnels.com/
 * @since      1.0.0
 *
 * @package    Wpfunnels_Pro_Integrations
 * @subpackage Wpfunnels_Pro_Integrations/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Wpfunnels_Pro_Integrations
 * @subpackage Wpfunnels_Pro_Integrations/admin
 * @author     WPFunnels Team <support@getwpfunnels.com>
 */

 use WPFunnelsPro\Integartions\Mailchimp\Wpfnl_Integartion_Mailchimp_functions;
 use WPFunnelsPro\Integartions\Mailpoet\Wpfnl_Integartion_Mailpoet_functions;
 use WPFunnelsPro\Integartions\ActiveCampaign\Wpfnl_Integartion_ActiveCampaign_functions;
 use WPFunnelsPro\Integartions\ConstantContact\Wpfnl_Integartion_ConstantContact_functions;
 use WPFunnelsPro\Integartions\SendInBlue\Wpfnl_Integartion_SendInBlue_functions;
 use WPFunnelsPro\Integartions\Aweber\Wpfnl_Integartion_Aweber_functions;
  use WPFunnelsPro\Integartions\Zapier\Wpfnl_Integartion_Zapier_functions;
 use WPFunnelsPro\Integartions\Mailerlite\Wpfnl_Integartion_Mailerlite_functions;
 use WPFunnelsPro\Integartions\GetResponse\Wpfnl_Integartion_GetResponse_functions;
 use WPFunnelsPro\Integartions\Encharge\Wpfnl_Integartion_Encharge_functions;
use WPFunnelsPro\Integartions\Hubspot\Wpfnl_Integartion_Hubspot_functions;

class Wpfunnels_Pro_Integrations_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wpfunnels_Pro_Integrations_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wpfunnels_Pro_Integrations_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		if( isset($_GET['page']) && 'wpfunnels_integrations' == $_GET['page'] ){
			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'assets/css/wpfunnels-pro-integrations-admin.css', array(), $this->version, 'all' );
		}
		
		
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wpfunnels_Pro_Integrations_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wpfunnels_Pro_Integrations_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		if( isset($_GET['page']) && 'wpfunnels_integrations' == $_GET['page'] ){
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'assets/js/wpfunnels-pro-integrations-admin.js', array( 'jquery' ), $this->version, false );
		}

	}


	/**
	 * Update supported crm 
	 */
	public function update_supported_crm( $crm ){

		if( !isset($crm['mailchimp']) ){
			if( Wpfnl_Integartion_Mailchimp_functions::maybe_mailchimp_enable() ){
				$crm['mailchimp'] = array(
					'class_name'    => 'Wpfnl_MailChimp',
				);
			}
		}

		if( is_plugin_active( 'mailpoet/mailpoet.php' ) ){
			if( !isset($crm['mailpoet']) ){
				if( Wpfnl_Integartion_Mailpoet_functions::maybe_mailpoet_enable() ){
					$crm['mailpoet'] = array(
						'class_name'    => 'Wpfnl_Mailpoet',
					);
				}
			}
		}

		if( Wpfnl_Integartion_ActiveCampaign_functions::maybe_active_campaign_enable() ){
			if( !isset($crm['activecampaign']) ){
				$crm['activecampaign'] = array(
					'class_name'    => 'Wpfnl_ActiveCampaign',
				);
			}
		}
		
		if( Wpfnl_Integartion_ConstantContact_functions::maybe_constant_contact_enable() ){
			if( !isset($crm['constantcontact']) ){
				$crm['constantcontact'] = array(
					'class_name'    => 'Wpfnl_ConstantContact',
				);
			}
		}

		if( Wpfnl_Integartion_Aweber_functions::maybe_aweber_enable() ){
			if( !isset($crm['aweber']) ){
				$crm['aweber'] = array(
					'class_name'    => 'Wpfnl_Aweber',
				);
			}
		}

		if( Wpfnl_Integartion_Zapier_functions::maybe_zapier_enable() ){
			if( !isset($crm['zapier']) ){
				$crm['zapier'] = array(
					'class_name'    => 'Zapier',
				);
			}
		}
		
		if( Wpfnl_Integartion_SendInBlue_functions::maybe_sendinblue_enable() ){
			if( !isset($crm['sendnnblue']) ){
				$crm['sendinblue'] = array(
					'class_name'    => 'Wpfnl_SendInBlue',
				);
			}
		}

		if( Wpfnl_Integartion_Mailerlite_functions::maybe_mailerlite_enable() ){
			if( !isset($crm['mailerlite']) ){
				$crm['mailerlite'] = array(
					'class_name'    => 'Wpfnl_Mailerlite',
				);
			}
		}

		if( Wpfnl_Integartion_GetResponse_functions::maybe_getresponse_enable() ){
			if( !isset($crm['getresponse']) ){
				$crm['getresponse'] = array(
					'class_name'    => 'Wpfnl_GetResponse',
				);
			}
		}
		if( Wpfnl_Integartion_Encharge_functions::maybe_encharge_enable() ){
			if( !isset($crm['encharge']) ){
				$crm['encharge'] = array(
					'class_name'    => 'Wpfnl_Encharge',
				);
			}
		}
		if( Wpfnl_Integartion_Hubspot_functions::maybe_hubspot_enable() ){
			if( !isset($crm['hubspot']) ){
				$crm['hubspot'] = array(
					'class_name'    => 'Wpfnl_Hubspot',
				);
			}
		}

		return $crm;
	}


	/**
	 * Add addons submenu under wpfunnels menu
	 * 
	 */
	public function register_addons_sub_menus(){
		
		add_submenu_page(
            'wp_funnels',
            __('Integrations', 'wpfnl'),
            __('Integrations', 'wpfnl'),
            'manage_options',
            WPFNL_PRO_INTEGRATIONS_MAIN_PAGE_SLUG,
            [$this, 'render_addons_page']
        );

		
	}


	public function render_addons_page(){
		require_once WPFNL_PRO_INTEGRATIONS_DIR . '/admin/partials/wpfunnels-pro-addon-view.php';
	}


	/**
     * register addon for licensing
     *
     * @param $addons
     * @return mixed
     *
     * @since 1.0.3
     */
    public function register_addon_for_licensing( $addons ) {

		if ( ! function_exists( 'get_plugins' ) || ! function_exists( 'is_plugin_active' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        $wp_function =  new \WPFunnelsPro\Wpfnl_Pro_functions();

		$addons['integrations'] = array(
                'key'           => 'integrations',
                'name'          => __( 'WPFunnels Pro - Integrations', 'wpfunnels-pro-integrations' ),
                'description'   => __( 'Integrate with your favorite CRM & Automation tools and send buyers data based on action in your sales funnels.', 'wpfunnels-pro-integrations' ),
                'icon'          => WPFNL_PRO_INTEGRATIONS_DIR . 'admin/partials/icons/integrations-icon.php',
                'slug'          => 'wpfunnels-pro-integrations/wpfunnels-pro-integrations.php',
                'version'       => WPFNL_PRO_INTEGRATIONS_VERSION,
                'plugin_status' => $this->check_plugin_installed('wpfunnels-pro-integrations/wpfunnels-pro-integrations.php') ? 'installed' : 'not-installed',
                'license_key'   => get_option( 'wpfunnels_pro_integrations_license_key'),
                'license_data'  => get_option( 'wpfunnels_pro_integrations_license_data' ),
                'license_status'=> get_option( 'wpfunnels_pro_integrations_license_status' ),
                'product_id'    =>  WPFNL_PRO_INTEGRATIONS_PRODUCT_ID,
                'dependency'    => 'pro',
                'btn_txt'       => $this->get_button_text('wpfunnels-pro-integrations/wpfunnels-pro-integrations.php'),
                'btn_link'      => $this->check_plugin_installed('wpfunnels-pro-integrations/wpfunnels-pro-integrations.php') ? admin_url('plugins.php') : 'https://getwpfunnels.com/pricing/',
		);
      

        return $addons;
    }


	/**
     * check if plugin is installed
     *
     * @param $plugin_slug
     * @return bool
     */
    public function check_plugin_installed( $plugin_slug ) {
        if ( ! function_exists( 'get_plugins' ) || ! function_exists( 'is_plugin_active' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $installed_plugins = get_plugins();
        return array_key_exists( $plugin_slug, $installed_plugins ) || in_array( $plugin_slug, $installed_plugins, true );
    }


	/**
     * get button text
     *
     * @param $slug
     * @return string|void
     *
     * @since 1.3.1
     */
    public function get_button_text( $slug ) {
        if ( !$this->check_plugin_installed( $slug ) ) {
            return __('Get the add-on', 'wpfunnels-pro-integrations');
        }

        if ( is_plugin_active( $slug ) ) {
            return __('Activated', 'wpfunnels-pro-integrations');
        }
        return __('Please enable', 'wpfunnels-pro-integrations');
    }


	/**
	 * Add new dashboard list 
	 * 
	 * @param Array
	 * @return Array
	 * @since 1.0.0
	 */
	public function add_dashboard_nav_lists( $list ){

		$list['integrations'] = [
				'title' => __('Integrations', 'wpfnl'),
				'icon'  => 'integration-icon',
				'page'  => WPFNL_PRO_INTEGRATIONS_MAIN_PAGE_SLUG,
		];

		return $list;
	}


	/**
	 * Delete transient for check update
	 * 
	 * @since 1.0.7
	 */
	public function check_update_transient(){
		delete_site_transient( 'update_plugins' );
		$this->clear_integration_update_check_transient();
	}


	/**
     * clear integration update check transient data
     *
     * @since 1.0.7
     */
    private function clear_integration_update_check_transient() {
        global $wpdb;
        $sql   = "DELETE a, b FROM $wpdb->options a, $wpdb->options b
		WHERE a.option_name LIKE %s
		AND a.option_name NOT LIKE %s
		AND b.option_name = CONCAT( '_site_transient_timeout_', SUBSTRING( a.option_name, 17 ) )";
        $wpdb->query( $wpdb->prepare( $sql, $wpdb->esc_like( '_site_transient_wpfunnels-pro-integrations-check_for_plugin_update' ) . '%', $wpdb->esc_like( '_site_transient_timeout_' ) . '%' ) );

    }

	/**
	 * Remove all the notice from integration page
	 * 
	 * @return void
	 * @since 1.2.5
	 */
	public function hide_update_notice_from_integration_page(){
		global $current_screen;
		if( 'wp-funnels_page_wpfunnels_integrations' === $current_screen->base){
			remove_all_actions( 'admin_notices' );
		}
	}
	
}
