<?php

namespace WPFunnelsPro\Integrations;

use Exception;
use WPFunnelsPro\Integartions\Mailchimp\Wpfnl_Integartion_Mailchimp_functions;
use WpfunnelsPro\Integrations\Wpfunnels_AES_Encription\Wpfunnels_Aes_Ctr;
use GuzzleHttp\Exception\GuzzleException;

class Wpfunnels_Integrations_Ajax {


    /**
     * 
	 * @since 1.0.0
	 */
	public function __construct()
	{
		$this->validations = [
			'logged_in' => true,
			'user_can' => 'manage_options',
		];
		wp_ajax_helper()->handle('wpfnl-update-addons-cred')
			->with_callback([$this, 'update_addons_cred'])
			->with_validation($this->validations);

        wp_ajax_helper()->handle('wpfnl-get-addons-cred')
			->with_callback([$this, 'get_addons_cred'])
			->with_validation($this->validations);

        wp_ajax_helper()->handle('wpfnl-update-crm-status')
                    ->with_callback([$this, 'update_crm_status'])
                    ->with_validation($this->validations);

        wp_ajax_helper()->handle('wpfnl-constant-contact-authentication')
                    ->with_callback([$this, 'wpfunnels_constant_contact_authentication'])
                    ->with_validation($this->validations);
                    
        wp_ajax_helper()->handle('wpfnl-aweber-authentication')
                    ->with_callback([$this, 'wpfunnels_aweber_authentication'])
                    ->with_validation($this->validations);

        wp_ajax_helper()->handle('wpfnl-sendinblue-authentication')
                    ->with_callback([$this, 'sendinblue_authentication'])
                    ->with_validation($this->validations);
                    
        wp_ajax_helper()->handle('wpfnl-mailerlite-authentication')
                    ->with_callback([$this, 'mailerlite_authentication'])
                    ->with_validation($this->validations);

        wp_ajax_helper()->handle('wpfnl-getresponse-authentication')
                    ->with_callback([$this, 'wpfunnels_getresponse_authentication'])
                    ->with_validation($this->validations); 
        
        wp_ajax_helper()->handle('wpfnl-encharge-authentication')
                    ->with_callback([$this, 'wpfunnels_encharge_authentication'])
                    ->with_validation($this->validations);

        wp_ajax_helper()->handle('wpfnl-hubspot-authentication')
                    ->with_callback([$this, 'wpfunnels_hubspot_authentication'])
                    ->with_validation($this->validations);


	}

    /**
     * Update addons credentials
     * 
     * @param Array
     * @return Array
     * 
     * @since 1.0.0
     */
    public function update_addons_cred( $payload ){

        if( $payload ){
            $creds = get_option( '_wpfnl_addons_cred' );
            /** update/save mailchimp creds */
            if( isset($payload['mailchimp_apikey']) && isset($payload['mailchimp_server'])  ){
                    $creds['mailchimp'] = [
                        'mailchimp_apikey' => $payload['mailchimp_apikey'] ? Wpfunnels_Aes_Ctr::encrypt( $payload['mailchimp_apikey'], WPFNL_SECURITY_KEY, 256 ) : '',
                        'mailchimp_server' => $payload['mailchimp_server'] ? Wpfunnels_Aes_Ctr::encrypt( $payload['mailchimp_server'], WPFNL_SECURITY_KEY, 256 ) : '',
                    ];
                    $mailchimp = Wpfnl_Integartion_Mailchimp_functions::get_mailchimp_obj();
                    if( $mailchimp ){
                        if( $payload['mailchimp_apikey'] && $payload['mailchimp_server'] ){
                            try{
                                
                                $mailchimp->setConfig([
                                    'apiKey' => $payload['mailchimp_apikey'],
                                    'server' => $payload['mailchimp_server']
                                ]);
            
                                $result = $mailchimp->root->getRoot();

                                if( $result ){
                                    $creds['mailchimp']['mailchimp_status'] = 'active';
                                    $creds['mailchimp']['status'] = 'active';
                                }else{
                                    $creds['mailchimp']['mailchimp_status'] = 'deactive';
                                    $creds['mailchimp']['status'] = 'active';
                                }
                            
                            }catch ( \WPFunnelsPro\Integrations\MailchimpMarketing\ApiException $e ) {

                                $creds['mailchimp']['mailchimp_status'] = 'deactive';
                                $creds['mailchimp']['status'] = 'active';
                            }catch( \WPFunnelsPro\Integrations\GuzzleHttp\Exception\RequestException $e ){
                                
                                $creds['mailchimp']['mailchimp_status'] = 'deactive';
                                $creds['mailchimp']['status'] = 'active';
                            }catch( \WPFunnelsPro\Integrations\GuzzleHttp\Exception\InvalidArgumentException $e ){
                                $creds['mailchimp']['mailchimp_status'] = 'deactive';
                                $creds['mailchimp']['status'] = 'active';
                            }catch( \Exception $e ){
                                
                                $creds['mailchimp']['mailchimp_status'] = 'deactive';
                                $creds['mailchimp']['status'] = 'active';
                            }
                        }else{
                            $creds['mailchimp']['mailchimp_status'] = 'deactive';
                            $creds['mailchimp']['status'] = 'active';
                        }
                    }
                    
            }

            /** update/save active campaign creds */
            if( isset($payload['active_camp_url']) && isset($payload['active_camp_api']) ){
                
                $creds['activecamp'] = [
                    'status'          => 'active',
                    'active_camp_url' => $payload['active_camp_url'],
                    'active_camp_api' => Wpfunnels_Aes_Ctr::encrypt( $payload['active_camp_api'], WPFNL_SECURITY_KEY, 256 ),
                ];

                try{
                    $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                    $response = $client->request('GET', "{$payload['active_camp_url']}/api/3/", [
                        'headers' => [
                            'Accept'        => 'application/json',
                            'api-token'     => "{$payload['active_camp_api']}",
                            
                        ],
                    ]);
                    
                    if( 200 == $response->getStatusCode() ){
                        $creds['activecamp']['activecamp_status'] = 'active';
                    }
                }catch(GuzzleException $e){
                    
                    $creds['activecamp']['activecamp_status'] = 'deactive';
                    
                }catch( \Exception $e ){
                    
                    $creds['activecamp']['activecamp_status'] = 'deactive';
                }

                
            }
            update_option( '_wpfnl_addons_cred', $creds );
            $this->get_addons_cred();

        }
        return [
            'success' => true
        ];
    }


    /**
     * Get addons credentials from option table
     * 
     * @return Array
     * @since 1.0.0
     */
    public function get_addons_cred(){

        $default_creds = [
            'mailchimp' => [
                'mailchimp_apikey' => '',
                'mailchimp_server' => '',
                'mailchimp_status'  => 'deactive',
                'status'            => 'deactive',
            ],
            'activecamp' => [
                'active_camp_url'    => '',
                'active_camp_api'    => '',
                'active_camp_status' => 'deactive',
                'status'             => 'deactive',
            ],
            'cc' => [
                'cc_url'    => '',
                'cc_api'    => '',
                'cc_secret' => '',
                'cc_code'   => '',
                'cc_state'  => '',
                'cc_status' => 'deactive',
                'status'             => 'deactive',
            ],
            'aweber' => [
                'aweber_url'    => '',
                'aweber_api'    => '',
                'aweber_secret' => '',
                'aweber_code'   => '',
                'aweber_state'  => '',
                'aweber_status' => 'deactive',
                'status'        => 'deactive',
            ],
            'getresponse' => [
                'getresponse_api'    => '',
                'getresponse_status' => 'deactive',
                'status'        => 'deactive',
            ],
            'encharge' => [
                'encharge_api'    => '',
                'encharge_status' => 'deactive',
                'status'        => 'deactive',
            ],

            'mailpoet' => [
                'status'             => 'deactive',
            ], 
            'zapier' => [
                'status'             => 'deactive',
            ],
            'sendinblue' => [
                'sendinblue_api'    => '',                   
                'sendinblue_status' => 'deactive',
                'status'        => 'deactive',
            ],
            'mailerlite' => [
                'mailerlite_api'    => '',                   
                'mailerlite_status' => 'deactive',
                'status'        => 'deactive',
            ],
            'hubspot' => [
                'hubspot_api'    => '',                   
                'hubspot_status' => 'deactive',
                'status'         => 'deactive',
            ],
        ];
        $creds = get_option( '_wpfnl_addons_cred' );
        
        if( $creds ){
            if( isset($creds['mailchimp']) && isset($creds['mailchimp']['mailchimp_apikey']) && isset($creds['mailchimp']['mailchimp_server']) && isset($creds['mailchimp']['status']) ){
                $creds['mailchimp']['mailchimp_apikey'] = Wpfunnels_Aes_Ctr::decrypt( $creds['mailchimp']['mailchimp_apikey'], WPFNL_SECURITY_KEY, 256 );
                $creds['mailchimp']['mailchimp_server'] = Wpfunnels_Aes_Ctr::decrypt( $creds['mailchimp']['mailchimp_server'], WPFNL_SECURITY_KEY, 256 );
                $creds['mailchimp']['mailchimp_status'] = isset($creds['mailchimp']['mailchimp_status']) && $creds['mailchimp']['mailchimp_status'] == 'active' ? 'active' : 'deactive';
            }

            if( isset($creds['activecamp']) && isset($creds['activecamp']['active_camp_url']) && isset($creds['activecamp']['active_camp_api']) && isset($creds['activecamp']['status']) ){
                $creds['activecamp']['active_camp_url'] = $creds['activecamp']['active_camp_url'];
                $creds['activecamp']['active_camp_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['activecamp']['active_camp_api'], WPFNL_SECURITY_KEY, 256 );
                $creds['activecamp']['activecamp_status'] = isset($creds['activecamp']['activecamp_status']) ? $creds['activecamp']['activecamp_status'] : 'deactive';
                $creds['activecamp']['status'] = $creds['activecamp']['status'];
            }

            if( isset($creds['cc']) && isset($creds['cc']['cc_url']) && isset($creds['cc']['cc_api']) && isset($creds['cc']['status']) && isset($creds['cc']['cc_secret']) ){
                $creds['cc']['cc_url'] = $creds['cc']['cc_url'];
                $creds['cc']['cc_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_api'], WPFNL_SECURITY_KEY, 256 );
                $creds['cc']['cc_secret'] = Wpfunnels_Aes_Ctr::decrypt( $creds['cc']['cc_secret'], WPFNL_SECURITY_KEY, 256 );
                $creds['cc']['cc_status'] = isset($creds['cc']['cc_status']) ? $creds['cc']['cc_status'] : 'deactive';
                $creds['cc']['status'] = $creds['cc']['status'];
            }
            
            if( isset($creds['aweber']) && isset($creds['aweber']['aweber_url']) && isset($creds['aweber']['aweber_api']) && isset($creds['aweber']['status']) && isset($creds['aweber']['aweber_secret']) ){
                $creds['aweber']['aweber_url'] = $creds['aweber']['aweber_url'];
                $creds['aweber']['aweber_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_api'], WPFNL_SECURITY_KEY, 256 );
                $creds['aweber']['aweber_secret'] = Wpfunnels_Aes_Ctr::decrypt( $creds['aweber']['aweber_secret'], WPFNL_SECURITY_KEY, 256 );
                $creds['aweber']['aweber_status'] = isset($creds['aweber']['aweber_status']) ? $creds['aweber']['aweber_status'] : 'deactive';
                $creds['aweber']['status'] = $creds['aweber']['status'];
            }
         
            if( isset($creds['sendinblue']) && isset($creds['sendinblue']['sendinblue_api']) && isset($creds['sendinblue']['status']) && isset($creds['sendinblue']['sendinblue_status']) ){
               
                $creds['sendinblue']['sendinblue_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['sendinblue']['sendinblue_api'], WPFNL_SECURITY_KEY, 256 );
                
                $creds['sendinblue']['sendinblue_status'] = isset($creds['sendinblue']['sendinblue_status']) ? $creds['sendinblue']['sendinblue_status'] : 'deactive';
                $creds['sendinblue']['status'] = $creds['sendinblue']['status'];
            }
            
            if( isset($creds['mailerlite']) && isset($creds['mailerlite']['mailerlite_api']) && isset($creds['mailerlite']['status']) && isset($creds['mailerlite']['mailerlite_status']) ){
               
                $creds['mailerlite']['mailerlite_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['mailerlite']['mailerlite_api'], WPFNL_SECURITY_KEY, 256 );
                
                $creds['mailerlite']['mailerlite_status'] = isset($creds['mailerlite']['mailerlite_status']) ? $creds['mailerlite']['mailerlite_status'] : 'deactive';
                $creds['mailerlite']['status'] = $creds['mailerlite']['status'];
            }

            if( isset($creds['getresponse']) && isset($creds['getresponse']['getresponse_api']) && isset($creds['getresponse']['status']) ){
               
                $creds['getresponse']['getresponse_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['getresponse']['getresponse_api'], WPFNL_SECURITY_KEY, 256 );
                $creds['getresponse']['getresponse_status'] = isset($creds['getresponse']['getresponse_status']) ? $creds['getresponse']['getresponse_status'] : 'deactive';
                $creds['getresponse']['status'] = $creds['getresponse']['status'];
            }
            if( isset($creds['encharge']) && isset($creds['encharge']['encharge_api']) && isset($creds['encharge']['status']) ){
               
                $creds['encharge']['encharge_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['encharge']['encharge_api'], WPFNL_SECURITY_KEY, 256 );
                $creds['encharge']['encharge_status'] = isset($creds['encharge']['encharge_status']) ? $creds['encharge']['encharge_status'] : 'deactive';
                $creds['encharge']['status'] = $creds['encharge']['status'];
            }

            if( isset($creds['hubspot']) && isset($creds['hubspot']['hubspot_api']) && isset($creds['hubspot']['status']) ){
               
                $creds['hubspot']['hubspot_api'] = Wpfunnels_Aes_Ctr::decrypt( $creds['hubspot']['hubspot_api'], WPFNL_SECURITY_KEY, 256 );
                $creds['hubspot']['hubspot_status'] = isset($creds['hubspot']['hubspot_status']) ? $creds['hubspot']['hubspot_status'] : 'deactive';
                $creds['hubspot']['status'] = $creds['hubspot']['status'];
            }

            if( !isset($creds['activecamp']) || !isset($creds['mailchimp']) || !isset($creds['mailpoet']) || !isset($creds['zapier']) || !isset($creds['cc']) || isset($creds['aweber']) ){
                if( !isset($creds['mailchimp']) ){
                    $creds['mailchimp'] = [
                        'mailchimp_apikey' => '',
                        'mailchimp_server' => '',
                        'mailchimp_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }

                if( !isset($creds['activecamp']) ){
                    $creds['activecamp'] = [
                        'active_camp_url'   => '',
                        'active_camp_api'   => '',
                        'activecamp_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }

                if( !isset($creds['cc']) ){
                    $creds['cc'] = [
                        'cc_url'   => '',
                        'cc_api'   => '',
                        'cc_secret' => '',
                        'cc_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }
                
                if( !isset($creds['aweber']) ){
                    $creds['aweber'] = [
                        'aweber_url'   => '',
                        'aweber_api'   => '',
                        'aweber_secret' => '',
                        'aweber_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }

                if( !isset($creds['mailpoet']) ){
                    $creds['mailpoet'] = [
                        'status' => 'deactive',
                    ];
                }
                if( !isset($creds['zapier']) ){
                    $creds['zapier'] = [
                        'status' => 'deactive',
                    ];
                }
                if( !isset($creds['sendinblue']) ){
                    $creds['sendinblue'] = [
                        'sendinblue_api'    => '',                   
                        'sendinblue_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }
                if( !isset($creds['mailerlite']) ){
                    $creds['mailerlite'] = [
                        'mailerlite_api'    => '',                   
                        'mailerlite_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }

                if( !isset($creds['getresponse']) ){
                    $creds['getresponse'] = [
                        'getresponse_api'   => '',
                        'getresponse_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }
                
                if( !isset($creds['encharge']) ){
                    $creds['encharge'] = [
                        'encharge_api'   => '',
                        'encharge_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }

                if( !isset($creds['hubspot']) ){
                    $creds['hubspot'] = [
                        'hubspot_api'   => '',
                        'hubspot_status' => 'deactive',
                        'status' => 'deactive',
                    ];
                }

            }

            $response['success'] = true;
            $response['data'] = $creds; 
        }else{
            $response['success'] = true;
            $response['data']    = $default_creds; 
        }
        
        return $response;
    }


    /**
     * Update crm status
     * 
     * @param Array
     * 
     * @return Array
     */
    public function update_crm_status( $payload ){
        if( isset($payload['crm']) && isset($payload['status']) ){

            $crm    = $payload['crm'];
            $status = $payload['status'];

            $default_creds = [
                'mailchimp' => [
                    'mailchimp_apikey'  => '',
                    'mailchimp_server'  => '',
                    'mailchimp_status'  => 'deactive',
                    'status'            => 'deactive',
                ],
                'activecamp' => [
                    'active_camp_url'    => '',
                    'active_camp_api'    => '',
                    'active_camp_status' => 'deactive',
                    'status'             => 'deactive',
                ],
                'cc' => [
                    'cc_url'    => '',
                    'cc_api'    => '',
                    'cc_secret'    => '',
                    'cc_status' => 'deactive',
                    'status'             => 'deactive',
                ],
                'aweber' => [
                    'aweber_url'    => '',
                    'aweber_api'    => '',
                    'aweber_secret' => '',
                    'aweber_status' => 'deactive',
                    'status'        => 'deactive',
                ],
                'getresponse' => [
                    'getresponse_api'    => '',
                    'getresponse_status' => 'deactive',
                    'status'        => 'deactive',
                ],
                'encharge' => [
                    'enchargee_api'     => '',
                    'encharge_status'   => 'deactive',
                    'status'            => 'deactive',
                ],
                'sendinblue' => [
                    'sendinblue_api'    => '',                   
                    'sendinblue_status' => 'deactive',
                    'status'        => 'deactive',
                ],
                'hubspot' => [
                    'hubspot_api'    => '',
                    'hubspot_status' => 'deactive',
                    'status'         => 'deactive',
                ],
            ];
            $creds = get_option( '_wpfnl_addons_cred' );
            if( $creds ){
                $creds[$crm]['status'] = $status;
                update_option( '_wpfnl_addons_cred', $creds );
            }else{
                $default_creds[$crm]['status'] = $status;
                update_option( '_wpfnl_addons_cred', $default_creds );
            }
            
            return [
                'success' => true,
                'data'    => 'Successfully updated',
            ];
        }
        return [
            'success' => true,
            'data'    => 'Fail to update',
        ];
    }


    /**
     * Constant Contact authentication
     * 
     * @param Array
     * @return Array
     * @since 1.0.3
     * 
     */
    public function wpfunnels_constant_contact_authentication( $payload ){
        if( isset($payload['cc_url']) && isset($payload['cc_api']) && isset($payload['cc_secret']) && $payload['cc_url'] && $payload['cc_api'] && $payload['cc_secret'] ){
            $auth_url = \WPFunnelsPro\Integartions\ConstantContact\Wpfnl_Integartion_ConstantContact_functions::cc_authentication( $payload['cc_api'], $payload['cc_url'] );

            if( $auth_url ){
                $creds = self::get_integration_credentials();

                $creds[ 'cc' ][ 'status' ]    = 'active';
                $creds[ 'cc' ][ 'cc_url' ]    = isset( $payload[ 'cc_url' ] ) ? $payload[ 'cc_url' ] : '';
                $creds[ 'cc' ][ 'cc_api' ]    = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'cc_api' ], WPFNL_SECURITY_KEY, 256 );
                $creds[ 'cc' ][ 'cc_secret' ] = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'cc_secret' ], WPFNL_SECURITY_KEY, 256 );

                update_option( '_wpfnl_addons_cred', $creds );
                self::register_action_scheduler( 6900, 'wpfunnels_constant_contact_authentication', 'cc' );

                return [
                    'success' => true,
                    'data'    => $auth_url,
                ];
            }
        }

        $creds = self::get_integration_credentials();

        $creds[ 'cc' ][ 'status' ]    = 'active';
        $creds[ 'cc' ][ 'cc_url' ]    = '';
        $creds[ 'cc' ][ 'cc_api' ]    = '';
        $creds[ 'cc' ][ 'cc_secret' ] = '';

        update_option( '_wpfnl_addons_cred', $creds );
        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
        ];
    }


    /**
     * @desc Register action scheduler if not already exists
     *
     * @param int $recurring_time
     * @param string $hook
     * @param string $integration
     * @return void
     */
    private static function register_action_scheduler( int $recurring_time, string $hook, string $integration = '' ) {
        $data[ 'data' ] = self::get_integration_credentials( $integration );

        if( function_exists( 'as_has_scheduled_action' ) ) {
            if( false === as_has_scheduled_action( $hook ) ) {
                as_schedule_recurring_action( time(), $recurring_time, $hook, $data );
            }
        }
        elseif( function_exists( 'as_next_scheduled_action' ) ) {
            if( false === as_next_scheduled_action( $hook ) ) {
                as_schedule_recurring_action( time(), $recurring_time, $hook, $data );
            }
        }
    }


    /**
     * @desc Get integration credentials data from database
     *
     * @param string $integration
     * @return false|mixed|void
     */
    public static function get_integration_credentials( string $integration = '' ) {
        $credentials = get_option( '_wpfnl_addons_cred', [] );
        return isset( $credentials[ $integration ] ) ? $credentials[ $integration ] : $credentials;
    }


    /**
     * AWeber authentication
     * 
     * @param Array
     * @return Array
     * @since 1.0.3
     * 
     */
    public function wpfunnels_aweber_authentication( $payload ){
        if( isset($payload['aweber_url']) && isset($payload['aweber_api']) && isset($payload['aweber_secret']) && $payload['aweber_url'] && $payload['aweber_api'] && $payload['aweber_secret'] ){
            $auth_url = \WPFunnelsPro\Integartions\Aweber\Wpfnl_Integartion_Aweber_functions::aweber_authentication( $payload['aweber_api'], $payload['aweber_url'] );

            if( $auth_url ) {
                $creds = self::get_integration_credentials();

                $creds[ 'aweber' ][ 'status' ]        = 'active';
                $creds[ 'aweber' ][ 'aweber_url' ]    = isset( $payload[ 'aweber_url' ] ) ? $payload[ 'aweber_url' ] : '';
                $creds[ 'aweber' ][ 'aweber_api' ]    = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'aweber_api' ], WPFNL_SECURITY_KEY, 256 );
                $creds[ 'aweber' ][ 'aweber_secret' ] = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'aweber_secret' ], WPFNL_SECURITY_KEY, 256 );

                update_option( '_wpfnl_addons_cred', $creds );
                self::register_action_scheduler( 6900, 'wpfunnels_aweber_authentication', 'aweber' );

                return [
                    'success' => true,
                    'data'    => $auth_url,
                ];
            }
        }
        $creds = self::get_integration_credentials();

        $creds[ 'aweber' ][ 'status' ]        = 'active';
        $creds[ 'aweber' ][ 'aweber_url' ]    = '';
        $creds[ 'aweber' ][ 'aweber_api' ]    = '';
        $creds[ 'aweber' ][ 'aweber_secret' ] = '';

        update_option( '_wpfnl_addons_cred', $creds );
        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
        ];
    }
    
    
    /**
     * GetResponse authentication
     * 
     * @param Array
     * @return Array
     * @since 1.0.11
     * 
     */
    public function wpfunnels_getresponse_authentication( $payload ){

        $creds = self::get_integration_credentials();
        if( isset($payload['getresponse_api']) ){
            $auth_url = \WPFunnelsPro\Integartions\GetResponse\Wpfnl_Integartion_GetResponse_functions::getresponse_authentication_url();
            if( $auth_url ) {
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                try {
                    $response = $client->request('GET', $auth_url."accounts", [
                        'headers' => [
                            'Content-Type'      => 'application/json',
                            'X-Auth-Token'      => 'api-key '. $payload['getresponse_api'],
                        ],
                    ]);
                    if( 200 == $response->getStatusCode() ){
                        $creds[ 'getresponse' ][ 'status' ]             = 'active';
                        $creds[ 'getresponse' ][ 'getresponse_status' ] = 'active';
                        $creds[ 'getresponse' ][ 'getresponse_api' ]    = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'getresponse_api' ], WPFNL_SECURITY_KEY, 256 );
                        update_option( '_wpfnl_addons_cred', $creds );
                        return [
                            'success' => true,
                            'data'    => 'Success',
                            'is_valid'=> 'deactive' == $creds['getresponse']['getresponse_status'] ? false : true
                        ];
                    }
                }catch (\Exception $e) {
                    $creds[ 'getresponse' ][ 'status' ]             = 'active';
                    $creds[ 'getresponse' ][ 'getresponse_status' ] = 'deactive';
                    $creds[ 'getresponse' ][ 'getresponse_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'getresponse_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }catch (GuzzleException $e) {

                    $creds[ 'getresponse' ][ 'status' ]             = 'active';
                    $creds[ 'getresponse' ][ 'getresponse_status' ] = 'deactive';
                    $creds[ 'getresponse' ][ 'getresponse_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'getresponse_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                  
                    $creds[ 'getresponse' ][ 'status' ]             = 'active';
                    $creds[ 'getresponse' ][ 'getresponse_status' ] = 'deactive';
                    $creds[ 'getresponse' ][ 'getresponse_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'getresponse_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }
            }
            
        }

        

        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
            'is_valid'=> false,
        ];
    }



    /**
     * Encharge authentication
     * 
     * @param Array $payload
     * @return Array
     * @since 1.0.12
     * 
     */
    public function wpfunnels_encharge_authentication( $payload ){

        $creds = self::get_integration_credentials();
        if( isset($payload['encharge_api']) ){
            $auth_url = \WPFunnelsPro\Integartions\Encharge\Wpfnl_Integartion_Encharge_functions::encharge_authentication_url();
            if( $auth_url ) {
                $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                try {
                    $response = $client->request('GET', $auth_url."accounts/info", [
                        'headers' => [
                            'Content-Type'      => 'application/json',
                            'X-Encharge-Token'      => $payload['encharge_api'],
                        ],
                    ]);
                    if( 200 == $response->getStatusCode() ){
                        $creds[ 'encharge' ][ 'status' ]             = 'active';
                        $creds[ 'encharge' ][ 'encharge_status' ] = 'active';
                        $creds[ 'encharge' ][ 'encharge_api' ]    = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'encharge_api' ], WPFNL_SECURITY_KEY, 256 );
                        update_option( '_wpfnl_addons_cred', $creds );
                        return [
                            'success' => true,
                            'data'    => 'Success',
                            'is_valid'=> 'deactive' == $creds['encharge']['encharge_status'] ? false : true
                        ];
                    }
                }catch (\Exception $e) {
                    $creds[ 'encharge' ][ 'status' ]             = 'active';
                    $creds[ 'encharge' ][ 'encharge_status' ] = 'deactive';
                    $creds[ 'encharge' ][ 'encharge_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'encharge_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }catch (GuzzleException $e) {

                    $creds[ 'encharge' ][ 'status' ]             = 'active';
                    $creds[ 'encharge' ][ 'encharge_status' ] = 'deactive';
                    $creds[ 'encharge' ][ 'encharge_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'encharge_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }catch (\WPFunnelsPro\Integrations\GuzzleHttp\Exception\ClientException $e) {
                  
                    $creds[ 'encharge' ][ 'status' ]          = 'active';
                    $creds[ 'encharge' ][ 'encharge_status' ] = 'deactive';
                    $creds[ 'encharge' ][ 'encharge_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'encharge_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }
            }
            
        }

        

        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
            'is_valid'=> false,
        ];
    }


    /**
     * Sendinblue authentication
     * 
     * @param Array
     * @return Array
     * @since 1.0.3
     * 
     */
    public function sendinblue_authentication( $payload ){
      
        if( isset($payload['sendinblue_api']) ){
            $config= \SendinBlue\Client\Configuration::getDefaultConfiguration()->setApiKey("api-key", $payload['sendinblue_api']);
            $config= \SendinBlue\Client\Configuration::getDefaultConfiguration()->setApiKey("partner-key", $payload['sendinblue_api']);
                
                $apiInstance = new \SendinBlue\Client\Api\AccountApi(
                    new \GuzzleHttp\Client(),
                    $config
                );
                $creds = get_option( '_wpfnl_addons_cred');
                try {
                    $result = $apiInstance->getAccount();
                    if( $result ){
                        $creds['sendinblue'] = [
                            'status'    => 'active',
                            'sendinblue_status'    => 'active',
                            'sendinblue_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['sendinblue_api'], WPFNL_SECURITY_KEY, 256 ),
                        ];
                    }else{
                        $creds['sendinblue'] = [
                            'status'    => 'active',
                            'sendinblue_status'    => 'deactive',
                            'sendinblue_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['sendinblue_api'], WPFNL_SECURITY_KEY, 256 ),
                        ];
                    }
                    
                } catch (Exception $e) {
                    $creds['sendinblue'] = [
                        'status'    => 'active',
                        'sendinblue_status'    => 'deactive',
                        'sendinblue_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['sendinblue_api'], WPFNL_SECURITY_KEY, 256 ),
                    ];
                    error_log(print_r($e->getMessage(),1));
                }catch( \SendinBlue\Client\ApiException $e ){
                    $creds['sendinblue'] = [
                        'status'    => 'active',
                        'sendinblue_status'    => 'deactive',
                        'sendinblue_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['sendinblue_api'], WPFNL_SECURITY_KEY, 256 ),
                    ];
                    error_log(print_r($e->getMessage(),1));
                   
                }
                update_option( '_wpfnl_addons_cred', $creds );
                return [
                    'success' => true,
                    'data'    => 'Success',
                    'is_valid'=> 'deactive' == $creds['sendinblue']['sendinblue_status'] ? false : true
                ];
        }
        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
        ];
    }

    /**
     * Mailerlite authentication
     * 
     * @param Array
     * @return Array
     * @since 1.0.7
     * 
     */
    public function mailerlite_authentication( $payload ){
        if( isset($payload['mailerlite_api']) ){
                $creds = get_option( '_wpfnl_addons_cred');
                try {
                    $client = new \WPFunnelsPro\Integrations\GuzzleHttp\Client();
                    $response = $client->request('GET', 'https://api.mailerlite.com/api/v2/me', [
                    'headers' => [
                        'Accept' => 'application/json',
                        'X-MailerLite-ApiDocs' => 'true',
                        'X-MailerLite-ApiKey' => $payload['mailerlite_api'],
                    ],
                    ]);
                   
                    if( 200 == $response->getStatusCode() ){
                        $result = json_decode($response->getBody()->getContents());
                     
                        if( $result ){
                            $creds['mailerlite'] = [
                                'status'    => 'active',
                                'mailerlite_status'    => 'active',
                                'mailerlite_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['mailerlite_api'], WPFNL_SECURITY_KEY, 256 ),
                            ];
                        }else{
                            $creds['mailerlite'] = [
                                'status'    => 'active',
                                'mailerlite_status'    => 'deactive',
                                'mailerlite_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['mailerlite_api'], WPFNL_SECURITY_KEY, 256 ),
                            ];
                        }
    
                    }
                    
                }catch (\Exception $e) {
                    $creds['mailerlite'] = [
                        'status'    => 'active',
                        'mailerlite_status'    => 'deactive',
                        'mailerlite_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['mailerlite_api'], WPFNL_SECURITY_KEY, 256 ),
                    ];
                    error_log(print_r($e->getMessage(),1));
                }catch (\WPFunnelsPro\Integrations\GuzzleHttp $e) {
                    $creds['mailerlite'] = [
                        'status'    => 'active',
                        'mailerlite_status'    => 'deactive',
                        'mailerlite_api'    => Wpfunnels_Aes_Ctr::encrypt( $payload['mailerlite_api'], WPFNL_SECURITY_KEY, 256 ),
                    ];
                    error_log(print_r($e->getMessage(),1));
                }
                update_option( '_wpfnl_addons_cred', $creds );
               
                return [
                    'success' => true,
                    'data'    => 'Success',
                    'is_valid'=> 'deactive' == $creds['mailerlite']['mailerlite_status'] ? false : true
                ];
        }
        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
        ];
    }

    /**
     * Hubspot authentication
     * 
     * @param Array $payload
     * @return Array
     * @since 1.2.0
     * 
     */
    public function wpfunnels_hubspot_authentication( $payload ){
        $creds = self::get_integration_credentials();
        if( isset($payload['hubspot_api']) ){
            $auth_url = \WPFunnelsPro\Integartions\Hubspot\Wpfnl_Integartion_Hubspot_functions::hubspot_authentication_url();
            
            if( $auth_url ) {
                try {
                    $response = wp_remote_request($auth_url.'crm/v3/objects/contacts', [
                        'headers' => [
                            'Authorization' => 'Bearer ' . $payload['hubspot_api'],
                            'Content-Type' => 'application/json',
                        ],
                    ]);

                    $status_code = wp_remote_retrieve_response_code($response);
 
                    if( 200 === $status_code){
                        $creds[ 'hubspot' ][ 'status' ]         = 'active';
                        $creds[ 'hubspot' ][ 'hubspot_status' ] = 'active';
                        $creds[ 'hubspot' ][ 'hubspot_api' ]    = Wpfunnels_Aes_Ctr::encrypt( $payload[ 'hubspot_api' ], WPFNL_SECURITY_KEY, 256 );
                        update_option( '_wpfnl_addons_cred', $creds );
                        return [
                            'success' => true,
                            'data'    => 'Success',
                            'is_valid'=> 'deactive' == $creds['hubspot']['hubspot_status'] ? false : true
                        ];
                    }
                }catch (\Exception $e) {
                    $creds[ 'hubspot' ][ 'status' ]         = 'active';
                    $creds[ 'hubspot' ][ 'hubspot_status' ] = 'deactive';
                    $creds[ 'hubspot' ][ 'hubspot_api' ]    =  Wpfunnels_Aes_Ctr::encrypt( $payload[ 'hubspot_api' ], WPFNL_SECURITY_KEY, 256 );
                    update_option( '_wpfnl_addons_cred', $creds );
                    
                    return [
                        'success' => false,
                        'data'    => 'Fail to authenticate',
                        'is_valid'=> false,
                    ];
                }
            }
            
        }

        return [
            'success' => false,
            'data'    => 'Fail to authenticate',
            'is_valid'=> false,
        ];
    }
}