<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://getwpfunnels.com/
 * @since             1.0.2
 * @package           Wpfnl_Pro_Gb
 *
 * @wordpress-plugin
 * Plugin Name:       WPFunnels Pro - Global Funnel
 * Plugin URI:        https://getwpfunnels.com/
 * Description:       Create a global sales funnel for your WooCommerce store and increase your sales using custom checkout pages and dynamic order bump, upsell & downsell offers.
 * Version:           1.1.4
 * Author:            WPFunnels Team
 * Author URI:        https://getwpfunnels.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wpfnl-pro-gb
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
use WPFunnelsProGB\Wpfnl_Pro_Gb;
use WPFunnelsProGB\Wpfnl_Pro_GBF_Updater;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */


define( 'WPFNL_PRO_GB_VERSION', '1.1.4' );
define('WPFNL_PRO_GB_PRODUCT_ID', 'wpf-gbf');

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
define('WPFNL_PRO_GB_INSTANCE', str_replace($protocol, "", get_bloginfo('wpurl')));

//license middleman api url
define('WPFNL_PRO_GB_LICENSE_URL', 'http://license.getwpfunnels.com:8888/api/v1/licence');

//the url where the WooCommerce Software License plugin is being installed
define('WPFNL_PRO_GB_API_URL', 'https://useraccount.getwpfunnels.com/');


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wpfnl-pro-gb-activator.php
 */
function activate_wpfnl_pro_gb() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/utils/class-wpfnl-pro-gb-activator.php';
	Wpfnl_Pro_Gb_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wpfnl-pro-gb-deactivator.php
 */
function deactivate_wpfnl_pro_gb() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/utils/class-wpfnl-pro-gb-deactivator.php';
	Wpfnl_Pro_Gb_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wpfnl_pro_gb' );
register_deactivation_hook( __FILE__, 'deactivate_wpfnl_pro_gb' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wpfnl-pro-gb.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wpfnl_pro_gb() {

	$plugin = new Wpfnl_Pro_Gb();
	$plugin->run();
    $license   = new \WPFunnelsPro\GBF\Wpfnl_Pro_GBF_Licensing();

}
run_wpfnl_pro_gb();


function add_global_funnel_controller($controllers) {
    $controllers['category']        = 'CategoryController';
    $controllers['product']         = 'ProductController';
    $controllers['globalFunnel']    = 'GlobalFunnelController';
    return $controllers;
}
add_filter('wpfunnels/rest_api_controllers', 'add_global_funnel_controller');


/**
 * redirect to license page after plugin activation
 * @since 1.0.24
 */
function wpfnl_pro_gbf_redirect() {
    if( is_plugin_active( 'wpfunnels-pro/wpfnl-pro.php' ) ){
        if (get_option('wpfunnels_pro_gbf_do_activation_redirect', false)) {
            delete_option('wpfunnels_pro_gbf_do_activation_redirect');

            // On these pages, or during these events, postpone the redirect.
            $do_redirect = true;
            if ( wp_doing_ajax() || is_network_admin() ) {
                $do_redirect = false;
            }
            if( $do_redirect ) {
                wp_redirect("admin.php?page=wpf-license");
            }
        }
    }else{
        delete_option('wpfunnels_pro_gbf_do_activation_redirect');
    }
}
add_action('admin_init', 'wpfnl_pro_gbf_redirect');


function run_wpfnl_gbf() {
	$plugin = new WPFunnelsProGB\Wpfnl_Pro_Gb();
	$plugin->run();
	new Wpfnl_GBF_Activation( 'wpfunnels-pro/wpfnl-pro.php', __FILE__, '1.0', 'wpfnl-pro-gb' );
}
run_wpfnl_gbf();

function wpfnl_pro_gbf_run_updater() {
    new Wpfnl_Pro_GBF_Updater( WPFNL_PRO_GB_API_URL, 'wpfunnels-pro-gbf', 'wpfunnels-pro-gbf/wpfnl-pro-gb.php' );
}

add_action('after_setup_theme', 'wpfnl_pro_gbf_run_updater');