<?php
use WPFunnels\Wpfnl_functions;

class Wpfnl_Pro_GB_Functions {


    /**
     * check if the funnel is global funnel or not
     *
     * @param $funnel_id
     * @return bool
     */
    public static function is_global_funnel( $funnel_id ) {
        if(!$funnel_id) {
            return false;
        }

        $is_global_funnel = get_post_meta( $funnel_id, 'is_global_funnel', true );
        if( $is_global_funnel && 'yes' === $is_global_funnel ) {
            return true;
        }
        return false;
    }


    /**
     * @param $funnel_id
     * @return bool|array
     */
    public static function get_global_funnel_start_condition( $funnel_id ) {
        if(!$funnel_id) {
            return false;
        }
        
        $global_condition = get_post_meta( $funnel_id, 'global_funnel_data', true );
        if( $global_condition && is_array( $global_condition ) && isset($global_condition['start_condition'])) {
            return $global_condition['start_condition'];
        }
        return false;
    }


    /**
     * Gbf feature dependency with gbf version
     * 
     * @since 1.0.7
     */
    public static function gbf_feature_dependency(){

        $features = array(
            array(
                'index'     => 'all_product',
                'label'     => 'Any product is selected',
                'version'   => '1.0.7',
            ),
        );

        return $features;
    }


    /**
     * maybe match ob product with main product
     * 
     * @param $ob_products, $main_products
     * @since 1.0.9
     * @return Array
     */
    public static function maybe_ob_match( $funnel_id,$ob_products, $main_products ){

        if( $funnel_id ){
            $is_global_funnel = get_post_meta( $funnel_id, 'is_global_funnel', true );
            if( 'yes' === $is_global_funnel ){
                $is_skip = get_post_meta( $funnel_id, '_wpfunnels_skip_offer', true );
                if( isset($is_skip['skip_offer']) && $is_skip['skip_offer'] === 'yes' ){
                    if( is_array( $ob_products ) ){
                        foreach( $ob_products as $key=>$ob_product ){
                            if( $ob_product['isEnabled'] || 'yes' === $ob_product['isEnabled'] ){
                                $index = array_search($ob_product['product'], array_column($main_products, 'id'));
                                if( false !== $index ){
                                    if( isset($is_skip['skip_if_quantity']) && $is_skip['skip_if_quantity'] === 'yes' ){
                                        if( (int)$main_products[$key]['quantity'] >= (int)$ob_product['quantity'] ){
                                            unset($ob_products[$key]);
                                        }
                                    }else{
                                        unset($ob_products[$key]);
                                    }
                                }
                            }
                            
                        }
                        
                    }
                }
            }
        }
        return $ob_products;
    }


    /**
     * maybe match offer product with main product
     * 
     * @param $offer_products, $main_products
     * @since 1.0.9
     * @return Bool
     */
    public static function maybe_match( $funnel_id,$offer_products, $main_products ){

        if( $funnel_id ){
            $is_global_funnel = get_post_meta( $funnel_id, 'is_global_funnel', true );
            if( 'yes' === $is_global_funnel ){
                $is_skip = get_post_meta( $funnel_id, '_wpfunnels_skip_offer', true );
                if( isset($is_skip['skip_offer']) && $is_skip['skip_offer'] === 'yes' ){
                    if( is_array($offer_products) ){
                        if( isset($offer_products['show']) ){
                            $index = array_search($offer_products['show'], array_column($main_products, 'id'));
                            if( false !== $index ){
                                if( isset($is_skip['skip_if_quantity']) && $is_skip['skip_if_quantity'] === 'yes' ){
                                    if( (int)$main_products[$index]['quantity'] >= (int)$offer_products['quantity'] ){                                      
                                        return true;
                                    }
                                }else{
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }


    /**
     * Get best selling product on woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_least_sold_product( $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            global $wpdb;
            $limit_clause = intval($limit) <= 0 ? '' : 'LIMIT '. intval($limit);
            $curent_month = date('Y-m-01 00:00:00');
            

            return (array) $wpdb->get_results("
                SELECT p.ID as id, COUNT(oim2.meta_value) as count
                FROM {$wpdb->prefix}posts p
                INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim
                    ON p.ID = oim.meta_value
                INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim2
                    ON oim.order_item_id = oim2.order_item_id
                INNER JOIN {$wpdb->prefix}woocommerce_order_items oi
                    ON oim.order_item_id = oi.order_item_id
                INNER JOIN {$wpdb->prefix}posts as o
                    ON o.ID = oi.order_id
                WHERE p.post_type = 'product'
                AND p.post_status = 'publish'
                AND o.post_status IN ('wc-processing','wc-completed')
                AND o.post_date >= '$curent_month'
                AND oim.meta_key = '_product_id'
                AND oim2.meta_key = '_qty'
                GROUP BY p.ID
                ORDER BY COUNT(oim2.meta_value) + 0 ASC
                $limit_clause
            ");
        }

    }


    /**
     * Get best selling product on woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_highest_sold_product( $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            global $wpdb;
            $limit_clause = intval($limit) <= 0 ? '' : 'LIMIT '. intval($limit);
            $curent_month = date('Y-m-01 00:00:00');

            return (array) $wpdb->get_results("
                SELECT p.ID as id, COUNT(oim2.meta_value) as count
                FROM {$wpdb->prefix}posts p
                INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim
                    ON p.ID = oim.meta_value
                INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim2
                    ON oim.order_item_id = oim2.order_item_id
                INNER JOIN {$wpdb->prefix}woocommerce_order_items oi
                    ON oim.order_item_id = oi.order_item_id
                INNER JOIN {$wpdb->prefix}posts as o
                    ON o.ID = oi.order_id
                WHERE p.post_type = 'product'
                AND p.post_status = 'publish'
                AND o.post_status IN ('wc-processing','wc-completed')
                AND o.post_date >= '$curent_month'
                AND oim.meta_key = '_product_id'
                AND oim2.meta_key = '_qty'
                GROUP BY p.ID
                ORDER BY COUNT(oim2.meta_value) + 0 DESC
                $limit_clause
            ");
        }
    }


    /**
     * Get most popular product on woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_most_popular_product( $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array(
                'post_type' 	=> array( 'product' ),
                'meta_key'  	=> 'total_sales',
                'orderby'   	=> 'meta_value_num',
                'order' 		=> 'desc',
                'posts_per_page'=> $limit ? $limit : 1
            );
            $popular_products = new WP_Query( $args );

            return (array)$popular_products;
        }
    }

    
    /**
     * Get avg rating product on woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_highest_avg_rating_product( $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array(
                'post_type' 	=> array( 'product' ),
                'orderby'        => 'meta_value_num',
                'order'          => 'desc',
                'meta_key'       => '_wc_average_rating',
                'posts_per_page'=> $limit ? $limit : 1
            );
            $highest_rating = new WP_Query( $args );

            return (array)$highest_rating;
        }
    }


    /**
     * Get most reviewed product on woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_most_reviewed_product( $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array(
                'post_type' 	=> array( 'product' ),
                'orderby'        => 'meta_value_num',
                'order'          => 'desc',
                'meta_key'       => '_wc_review_count',
                'posts_per_page'=> $limit ? $limit : 1
            );
            $most_reviewed = new WP_Query( $args );

            return (array)$most_reviewed;
        }
        
    }


    /** 
     * Compare current date to a date range
     * 
     * 
     * @param mixed current_date
     * @param mixed $rule
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function date_is_within_date_range( $current_date, $rule) {
        $current_date = date('Y-m-d', strtotime($current_date));
        $startDate    = date('Y-m-d', strtotime($rule['startDate']));
        $endDate      = date('Y-m-d', strtotime($rule['endDate']));
        if(($current_date >= $startDate) && ($current_date <= $endDate)){
            return true;
        }else{
            return false;
        }
    }


    /**
     * Get best selling product on woo shop
     * 
     * @param String
     * @return Array
     * 
     * @param mixed $current_date
     * @param $rule
     * 
     * @return array
     */
    public static function get_highest_sold_product_for_offer( $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array(
                'post_type'      => array( 'product' ),
                'meta_key'       => 'total_sales',
                'orderby'        => 'meta_value_num',
                'posts_per_page' => $limit ? $limit : 1
            );
            $highest_sold = new WP_Query( $args );
            return (array)$highest_sold;
        }
    }


    /** 
     * Compare current date to order date
     * 
     * @param mixed $value 
     * 
     * @return bool 
     * 
    */ 
    public static function date_is_similiar_to_current_date( $current_date, $rule ) { 
        $current_date = date( 'Y-m-d', strtotime( $current_date ) ); 
        $date = date( 'Y-m-d', strtotime( $rule['date'] ) ); 
        if( $date == $current_date ){ 
            return true; 
        }
        else{ 
            return false; 
        } 
    }


    /**
     * Get best selling product on woo shop in a category
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     */
    public static function get_highest_sold_product_in_category_for_offer( $limit = '-1', $category){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type' => array( 'product' ),
                'posts_per_page' => $limit ? $limit : 1, 
                'product_cat' => $category, 
                'meta_key'      => 'total_sales',
                'orderby'       => 'meta_value_num', 
            );
            $highest_sold = new WP_Query( $args );
            return (array)$highest_sold;
        }
    }


    /**
     * Get best selling product on woo shop in a tag
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     */
    public static function get_highest_sold_product_in_tag_for_offer(  $tag_id, $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            $tag = get_term( $tag_id );
            if( isset($tag->slug) ){
                $args = array( 
                    'post_type' => array( 'product' ),
                    'posts_per_page' => $limit ? $limit : 1, 
                    'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_tag',
                            'field'    => 'slug',
                            'terms'    => $tag->slug,
                        )
                    ),
                    'meta_key'      => 'total_sales',
                    'orderby'       => 'meta_value_num', 
                );
                $highest_sold = new WP_Query( $args );
                return (array)$highest_sold;
            }
        }
    }


    /**
     * Get best selling product on woo shop in a tag
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     */
    public static function get_highest_sold_product_in_tag_for_offer_for_widget(  $tag_id, $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            $tag = get_term( $tag_id );
            if( isset($tag->slug) ){
                $args = array( 
                    'post_type' => array( 'product' ),
                    'posts_per_page' => $limit ? $limit : 1, 
                    'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_tag',
                            'field'    => 'slug',
                            'terms'    => $tag->slug,
                        )
                    ),
                    'meta_key'      => 'total_sales',
                    'orderby'       => 'meta_value_num', 
                );
                $highest_sold = new WP_Query( $args );
                return (array)$highest_sold;
            }
            return [];
        }
    }



    /**
     * Updates random products which has been offered on render
     * 
     * @param String
     * @return void
     * 
     * @since 1.0.14
     * 
     */
    public static function get_random_product_in_category_for_offer( $limit = '-1', $category){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type'         => array( 'product' ),
                'posts_per_page'    => $limit ? $limit : 1, 
                'status'            => 'publish',
                'product_cat'       => $category,
                'orderby'           => 'rand', 
                'suppress_filters'  => true,
            );
            $rand_product = new WP_Query( $args );
            update_option( 'wpfunnels_dynamic_offer_data', wp_json_encode($rand_product->posts) );
        }
    }


    /**
     * Get random product on woo shop in a category
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_random_product_in_category_within_price_for_offer( $category, $priceFrom, $priceTo, $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type'         => array( 'product' ),
                'posts_per_page'    => $limit ? $limit : 1, 
                'status'            => 'publish',
                'product_cat'       => $category,
                'orderby'           => 'rand', 
                'suppress_filters'  => true,
                'meta_query' => array(
                    array(
                        'key' => '_price',
                        'value' => array($priceFrom, $priceTo),
                        'compare' => 'BETWEEN',
                        'type' => 'NUMERIC'
                    ),
                ),
            );
            $rand_product = new WP_Query( $args );
            update_option( 'wpfunnels_dynamic_offer_data', wp_json_encode($rand_product->posts) );
        }
    }


    /**
     * Get random product on woo shop in a tag
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_random_product_in_tag_for_offer( $limit = '-1', $tag_id){
        if( Wpfnl_functions::is_wc_active() ){
            if( !get_option( 'wpfunnels_dynamic_offer_data' ) ){
                $tag = get_term( $tag_id );
                if( isset($tag->slug) ){
                    $args = array( 
                        'post_type'         => array( 'product' ),
                        'status'            => 'publish',
                        'posts_per_page'    => $limit ? $limit : 1, 
                        'orderby'           => 'rand', 
                        'suppress_filters'  => true,
                        'tax_query' => array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_tag',
                                'field'    => 'slug',
                                'terms'    => $tag->slug,
                            )
                        ),
                    );
                    $rand_product = new WP_Query( $args );
                    update_option( 'wpfunnels_dynamic_offer_data', wp_json_encode($rand_product->posts) );
                }
            }
        }
    }


    /**
     * Get random product on woo shop in a tag
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.14
     * 
     */
    public static function get_random_product_in_tag_within_price_for_offer(  $tag_id , $priceFrom, $priceTo, $limit = '-1'){
        if( Wpfnl_functions::is_wc_active() ){
            if( !get_option( 'wpfunnels_dynamic_offer_data' ) ){
                $tag = get_term( $tag_id );
                if( isset($tag->slug) ){
                    $args = array( 
                        'post_type'         => array( 'product' ),
                        'status'            => 'publish',
                        'posts_per_page'    => $limit ? $limit : 1, 
                        'orderby'           => 'rand', 
                        'suppress_filters'  => true,
                        'tax_query' => array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_tag',
                                'field'    => 'slug',
                                'terms'    => $tag->slug,
                            )
                        ),
                        'meta_query' => array(
                            array(
                                'key' => '_price',
                                'value' => array($priceFrom, $priceTo),
                                'compare' => 'BETWEEN',
                                'type' => 'NUMERIC'
                            ),
                        ),
                    );
                    $rand_product = new WP_Query( $args );
                    update_option( 'wpfunnels_dynamic_offer_data', wp_json_encode($rand_product->posts) );
                }
            }
        }
    }


    /**
     * Get random product in woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.19
     * 
     */
    public static function get_random_product_in_tag_within_price_for_offer_for_widget( $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type'         => array( 'product' ),
                'posts_per_page'    => $limit ? $limit : 1, 
                'meta_key'          => 'total_sales',
                'orderby'           => 'rand', 
                'suppress_filters'  => true,
            );
            $random_product = new WP_Query( $args );
            return isset($random_product->posts) ? $random_product->posts : [];
        }
    }

    /**
     * Get random product in woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.19
     * 
     */
    public static function get_random_product_in_category_within_price_for_offer_for_widget( $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type'         => array( 'product' ),
                'posts_per_page'    => $limit ? $limit : 1, 
                'meta_key'          => 'total_sales',
                'orderby'           => 'rand', 
                'suppress_filters'  => true,
            );
            $random_product = new WP_Query( $args );
            return isset($random_product->posts) ? $random_product->posts : [];
        }
    }


    /**
     * Get random product in woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.19
     * 
     */
    public static function get_random_product_in_tag_for_offer_for_widget( $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type'         => array( 'product' ),
                'posts_per_page'    => $limit ? $limit : 1, 
                'meta_key'          => 'total_sales',
                'orderby'           => 'rand', 
                'suppress_filters'  => true,
            );
            $random_product = new WP_Query( $args );
            return isset($random_product->posts) ? $random_product->posts : [];
        }
    }


    /**
     * Get random product in woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.19
     * 
     */
    public static function get_random_product_in_shop( $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            if( !get_option( 'wpfunnels_dynamic_offer_data' ) ){
                $args = array( 
                    'post_type'         => array( 'product' ),
                    'posts_per_page'    => $limit ? $limit : 1, 
                    'meta_key'          => 'total_sales',
                    'orderby'           => 'rand', 
                    'suppress_filters'  => true,
                );
                $random_product = new WP_Query( $args );
                update_option( 'wpfunnels_dynamic_offer_data', wp_json_encode($random_product->posts) );
            }
        }
    }


    /**
     * Get random product in woo shop
     * 
     * @param String
     * @return Array
     * 
     * @since 1.0.19
     * 
     */
    public static function get_random_product_in_shop_for_widget( $limit = '-1' ){
        if( Wpfnl_functions::is_wc_active() ){
            $args = array( 
                'post_type'         => array( 'product' ),
                'posts_per_page'    => $limit ? $limit : 1, 
                'meta_key'          => 'total_sales',
                'orderby'           => 'rand', 
                'suppress_filters'  => true,
            );
            $random_product = new WP_Query( $args );
            return isset($random_product->posts) ? $random_product->posts : [];
        }
    }


    /**
     * Check user is returning customer or not
     * 
     * @param Number $user_id
     * @return Bool
     * @since 1.0.25
     */
    public static function maybe_returning_user( $user_id = 0 ) {
        if ( ! is_user_logged_in() && $user_id === 0 ) {
            return false;
        }

        global $wpdb;
        $count = $wpdb->get_var( $wpdb->prepare("
            SELECT COUNT(cus.customer_id) FROM {$wpdb->prefix}wc_customer_lookup AS cus
            WHERE cus.user_id = '%s'
            LIMIT 1
        ", $user_id ) );
        
        return $count > 0;
    }


    /**
     * Check user is returning customer or not within last X days
     * 
     * @param Number $user_id
     * @param Number $days
     * 
     * @return Bool 
     * 
     * @since 1.0.25
     */
    public static function maybe_returning_user_within_days( $user_id = 0, $days ) {
        if ( ! is_user_logged_in() && $user_id === 0 ) {
            return false;
        }

        global $wpdb;
        $count = $wpdb->get_var( $wpdb->prepare("
            SELECT COUNT(cus.customer_id) FROM {$wpdb->prefix}wc_customer_lookup AS cus
            WHERE cus.user_id = '%s'
            AND cus.date_last_active > NOW() - INTERVAL '%s' DAY
            LIMIT 1
        ", $user_id, $days ) );
        return $count > 0;
    }

    /**
     * Updates the product price based on the quantity.
     *
     * @param int   $quantity      The quantity to update the prices for.
     * @param array $offer_product The array of offer product information.
     *
     * @return array The updated offer product information with adjusted prices.
     * @since 1.1.3
     */
    public static function update_product_price_on_quantity( $quantity = 0, $offer_product = []){
        if ( isset( $offer_product['qty'], $offer_product['unit_price'], $offer_product['unit_price_tax'], $offer_product['args'], $offer_product['price'],  $offer_product['total'] )){
            $subtotal = isset( $offer_product['args']['subtotal'] ) ? (float)$offer_product['args']['subtotal'] : (float)$offer_product['unit_price'];
            $total    = isset( $offer_product['args']['total'] ) ? (float)$offer_product['args']['total'] : (float)$offer_product['unit_price'];

            $quantity = (float)$quantity;

            $offer_product['qty']              = (float)$offer_product['qty'] * $quantity;
            $offer_product['unit_price']       = (float)$offer_product['unit_price'] * $quantity;
            $offer_product['unit_price_tax']   = (float)$offer_product['unit_price_tax'] * $quantity;
            $offer_product['args']['subtotal'] = $subtotal * $quantity;
            $offer_product['args']['total']    = $total * $quantity;
            $offer_product['price']            = (float)$offer_product['price'] * $quantity;
            $offer_product['total']            = (float)$offer_product['total'] * $quantity;
        }
        return $offer_product;
    }


}