<?php

namespace WPFunnels\Rest\Controllers;

use WP_Error;
use WP_REST_Request;
use WPFunnels\Wpfnl_functions;
use WPFunnelsProGBF\Conditions;

class ProductController extends Wpfnl_REST_Controller
{
    
    /**
     * Endpoint namespace.
     *
     * @var string
     */
    protected $namespace = 'wpfunnels/v1';

    /**
     * Route base.
     *
     * @var string
     */
    protected $rest_base = 'product';


    /**
     * check if user has valid permission
     *
     * @param $request
     * @return bool|WP_Error
     * @since 1.0.0
     */
    public function update_items_permissions_check($request)
    {   
        return true;
        if (!Wpfnl_functions::wpfnl_rest_check_manager_permissions( 'step', 'edit' )) {
            return new WP_Error('wpfunnels_rest_cannot_edit', __('Sorry, you cannot edit this resource.', 'wpfnl'), ['status' => rest_authorization_required_code()]);
        }
        return true;
    }

    /**
     * Makes sure the current user has access to READ the settings APIs.
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|boolean
     * @since  1.0.0
     */
    public function get_items_permissions_check($request)
    {
        if (!Wpfnl_functions::wpfnl_rest_check_manager_permissions('settings')) {
            return new WP_Error('wpfunnels_rest_cannot_view', __('Sorry, you cannot list resources.', 'wpfnl'), ['status' => rest_authorization_required_code()]);
        }
        return true;
    }

    /**
     * register rest routes
     *
     * @since 1.0.0
     */
    public function register_routes()
    {

        register_rest_route($this->namespace, '/' . $this->rest_base . '/getProductsByCategoryAndName/(?P<category_id>\d+)', [
            [
                'methods' => \WP_REST_Server::READABLE,
                'callback' => [
                    $this,
                    'get_product_by_category_and_name'
                ], 
                'permission_callback' => [
                    $this,
                    'update_items_permissions_check'
                ] ,
            ],
        ]);

    }

    /**
     * Search product by category id and name
     * 
     * @param WP_REST_Request $request Full data about the request.
     * 
     * @since 1.0.0
     */
    public function get_product_by_category_and_name(\WP_REST_Request $request){
        $category_id    = $request['category_id'];
        $product_name = $request->get_param( 'product_name' );
        $args = array(         
            'post_status'       => 'publish',
            'posts_per_page'    => -1,
            'post_type'         => ['product','product_variation'],
            's'                 => $product_name,
            'tax_query'         => array(
                array(
                    'taxonomy'    => 'product_cat',
                    'field'       => 'term_id',
                    'terms'       =>  $category_id,
                    'operator'    =>  'IN',
                )    
            )
        );
        $products = get_posts($args);
        if(empty($products)){
            return [
                'status'  => 'success',
                'data'    => 'Product not found',
              ];
        }

        return [
            'status'  => 'success',
            'data'    => $products,
          ];
    }


}