<?php

namespace WPFunnels\Rest\Controllers;

use WP_Error;
use WP_REST_Request;
use WPFunnels\Wpfnl_functions;
use WPFunnelsProGBF\Conditions;

class CategoryController extends Wpfnl_REST_Controller
{
    
    /**
     * Endpoint namespace.
     *
     * @var string
     */
    protected $namespace = 'wpfunnels/v1';

    /**
     * Route base.
     *
     * @var string
     */
    protected $rest_base = 'category';


    /**
     * check if user has valid permission
     *
     * @param $request
     * @return bool|WP_Error
     * @since 1.0.0
     */
    public function update_items_permissions_check($request)
    {   
        return true;
        if (!Wpfnl_functions::wpfnl_rest_check_manager_permissions( 'step', 'edit' )) {
            return new WP_Error('wpfunnels_rest_cannot_edit', __('Sorry, you cannot edit this resource.', 'wpfnl'), ['status' => rest_authorization_required_code()]);
        }
        return true;
    }

    
    /**
     * Makes sure the current user has access to READ the settings APIs.
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|boolean
     * @since  3.0.0
     */
    public function get_items_permissions_check($request)
    {
        if (!Wpfnl_functions::wpfnl_rest_check_manager_permissions('settings')) {
            return new WP_Error('wpfunnels_rest_cannot_view', __('Sorry, you cannot list resources.', 'wpfnl'), ['status' => rest_authorization_required_code()]);
        }
        return true;
    }


    /**
     * register rest routes
     *
     * @since 1.0.0
     */
    public function register_routes()
    {
        register_rest_route($this->namespace, '/' . $this->rest_base . '/getCategory'. '/(?P<funnel_id>\d+)', [
            array(
                'methods' => 'GET',
                'args' => array(
                    'funnel_id' => array(
                        'description'   => __('Funnel ID.', 'wpfnl'),
                        'type'          => 'string',
                    )
                ),
                'callback' => [
                    $this,
                    'get_category'
                ],
                'permission_callback' => [
                    $this,
                    'update_items_permissions_check'
                ] ,
            ),
        ]);

    }


    /**
     * Get all categories
     */
    public function get_category(\WP_REST_Request $request){
        if (isset($request['funnel_id'])){
            $funnel_id 	= $request['funnel_id'];
        }
        $get_start_condition = get_post_meta($funnel_id,'global_funnel_start_condition',true) ;
        $category_data = [];
        foreach($get_start_condition as $condtions){
            foreach ($condtions as $value){
                $category_id    = $value['value'][0];
                $get_term = $this->get_name_by_term_id($category_id);
                $category_data = [
                    'param' => $value['param'],
                    'operator' =>$value['operator'],
                    'value' =>array(
                        'id' => $category_id,
                        'name' => $get_term['name'],
                        'slug' => $get_term['slug']
                    )
                ];
            }
        }
        if ($category_data) {
            return array(
                'status' => 'success',
                'data' => $category_data,
            );
        }
        return array(
            'status' => 'error',
            'data' => '',
        );
    }

    public function get_name_by_term_id($term_id){
        $get_term = get_term_by('id',$term_id,'product_cat');
        if(!$get_term){
            return 'not found';
        }
        $term = [
            'name' => $get_term->name,
            'slug' => $get_term->slug,
        ];
        return  $term;
    }
}