<?php
/**
 * @author [Getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-06-20 13:45:25
 * @modify date 2022-06-20 13:45:25
 * @desc [Factory class which is responsible for creating gbf condition based object]
 */

use WPFunnels\Traits\SingletonTrait;


class Wpfnl_Pro_GBF_Offer_Conditions_Factory {
    use SingletonTrait;

    /**
     * Build instance for GBF conditional based classes
     * 
     * @param mixed $module conditional value from upsell setting
     * 
     * @return object
     */
    public static function build($module)
    {
        $class_name = "WPFunnelsProGBF\\Conditions\\Offer\\".ucfirst($module);
        if (!class_exists(ucfirst($class_name))) {
            throw new \Exception('Invalid Condition Module.');
        } else {
            return new $class_name();
        }
    }
}