<?php
namespace WPFunnelsProGBF\Conditions\Offer;

/**
 * @author [Getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-06-20 13:56:42
 * @modify date 2022-06-20 13:56:42
 * @desc [Get offer product when GBF condition on upsell is "Specific Product"]
 */

use WPFunnelsPro\Wpfnl_Pro_functions;

class SpecificProduct extends Wpfnl_Pro_GBF_Conditions {

    /**
     * Get dynamic offer product for upsell or downsell
     * 
     * @param mixed $offer_mappings
     * @param mixed $order_id
     * @param mixed $step_id
     * @param mixed $gbf_product
     * 
     * @return array
     */
    public function get_offer_product( $offer_mappings, $order_id, $step_id, $gbf_product ) {
        $offer_product      = array();
        $offer_product      = Wpfnl_Pro_functions::get_offer_data( $step_id, $offer_mappings['show'], $offer_mappings['quantity'], $order_id );
        return $offer_product;
    }

}