<?php
namespace WPFunnelsProGBF\Conditions\Offer;

/**
 * @author [Getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-06-21 17:29:35
 * @modify date 2022-06-21 17:29:35
 * @desc [Get offer product when GBF condition on upsell and downsell is "Random product in category"]
 */

use WPFunnelsPro\Wpfnl_Pro_functions;
use Wpfnl_Pro_GB_Functions;

class RandomProductInsideTagWithinPrice extends Wpfnl_Pro_GBF_Conditions {

    /**
     * Get dynamic offer product for upsell or downsell
     * Offer product will be random product of a catefory
     * @param mixed $offer_mappings
     * @param mixed $order_id
     * @param mixed $step_id
     * @param mixed $gbf_product
     * 
     * @return array
     * 
     * @since 1.0.15
     */
    public function get_offer_product( $offer_mappings, $order_id, $step_id, $gbf_product ) {
        $offer_product = array();
        $show          = isset($offer_mappings['show']) ? $offer_mappings['show'] : null;
        $tag           = isset($offer_mappings['tag']) ? $offer_mappings['tag'] : null;
        $priceFrom           = isset($offer_mappings['priceFrom']) ? $offer_mappings['priceFrom'] : null;
        $priceTo           = isset($offer_mappings['priceTo']) ? $offer_mappings['priceTo'] : null;
        $quantity      = isset($offer_mappings['quantity']) ? $offer_mappings['quantity'] : null;
        
        if( !get_option( 'wpfunnels_dynamic_offer_data' ) ){
            
            Wpfnl_Pro_GB_Functions::get_random_product_in_tag_within_price_for_offer( $tag, $priceFrom, $priceTo, 1 );
        }
        $order = wc_get_order($order_id);
        $dynamic_product   = json_decode( wp_unslash( get_option( 'wpfunnels_dynamic_offer_data' ) ), true );
       
        /**
         * Assign dynamic product as a offer product
         */
        if( is_array($dynamic_product) && isset($dynamic_product[0]['ID'])){
            $already_ordered = false;
            // check dynamic product already in order or not
            if( $order ){
                foreach ( $order->get_items() as $item_id => $item ) {
                    $product_id = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
                    if( $dynamic_product[0]['ID'] == $product_id ){
                        $already_ordered = true;
                    }
                }
    
            }
            
            if( !$already_ordered ){
                $show = $dynamic_product[0]['ID'];  
            }else{

                // if dynamic product already in order then regenerate dynamic product again 
                delete_option( 'wpfunnels_dynamic_offer_data' );
                Wpfnl_Pro_GB_Functions::get_random_product_in_tag_within_price_for_offer( $tag, $priceFrom, $priceTo, 1);
                $dynamic_product   = json_decode( wp_unslash( get_option( 'wpfunnels_dynamic_offer_data' ) ), true );
                if( is_array($dynamic_product) && isset($dynamic_product[0]['ID'])){
                    $show = $dynamic_product[0]['ID'];  
                }
            }
            
        }else{
            delete_option( 'wpfunnels_dynamic_offer_data' );
            return [];
        }

        $offer_product = Wpfnl_Pro_functions::get_offer_data( $step_id, $show, $quantity, $order_id );
        return $offer_product;
    }

}