<?php
namespace WPFunnelsProGBF\Conditions\Offer;

/**
 * @author [Getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-06-20 13:56:42
 * @modify date 2022-06-20 13:56:42
 * @desc [Get offer product when GBF condition on upsell is "More Quantity of the main product in cart"]
 */

use WPFunnelsPro\Wpfnl_Pro_functions;

class MoreQuantity extends Wpfnl_Pro_GBF_Conditions {

    /**
     * Get dynamic offer product for upsell or downsell
     * 
     * @param mixed $offer_mappings
     * @param mixed $order_id
     * @param mixed $step_id
     * @param mixed $gbf_product
     * 
     * @return array
     */
    public function get_offer_product( $offer_mappings, $order_id, $step_id, $gbf_product ) {
        $offer_product      = array();
        $offer_mappings['show'] = isset($gbf_product[0]['variation_id']) ? $gbf_product[0]['variation_id'] : (isset($gbf_product[0]['id']) ? $gbf_product[0]['id'] : '');
        $offer_mappings['quantity'] =  $offer_mappings['quantity'] + ( isset($gbf_product[0]['quantity']) ? $gbf_product[0]['quantity'] : 0 );
        $offer_product      = Wpfnl_Pro_functions::get_offer_data( $step_id, $offer_mappings['show'], $offer_mappings['quantity'], $order_id );
        
        return $offer_product;
    }

}