<?php
namespace WPFunnelsProGBF\Conditions\Offer;

/**
 * @author [Getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-06-20 13:56:42
 * @modify date 2022-06-20 13:56:42
 * @desc [Get offer product when GBF condition on upsell is "Heighest sold product in a category"]
 */

use WPFunnelsPro\Wpfnl_Pro_functions;
use Wpfnl_Pro_GB_Functions;

class HighestSoldInsideCategory extends Wpfnl_Pro_GBF_Conditions {

    /**
     * Get dynamic offer product for upsell or downsell
     * Offer product will be highest sold product in a category
     * @param mixed $offer_mappings
     * @param mixed $order_id
     * @param mixed $step_id
     * @param mixed $gbf_product
     * 
     * @return array
     */
    public function get_offer_product( $offer_mappings, $order_id, $step_id, $gbf_product ) {
        $offer_product      = array();
        $category = $offer_mappings['category'];
        $highest_sold      = Wpfnl_Pro_GB_Functions::get_highest_sold_product_in_category_for_offer( 1, $category );
        if( is_array($highest_sold) && isset($highest_sold['posts'][0]->ID)){
            $offer_mappings['show'] = $highest_sold['posts'][0]->ID;  
        }
        $offer_product      = Wpfnl_Pro_functions::get_offer_data( $step_id, $offer_mappings['show'], $offer_mappings['quantity'], $order_id );
        return $offer_product;
    }

}