<?php

namespace WPFunnelsProGBF\Conditions;

class Tag extends Wpfnl_Pro_GBF_Conditions {

    /**
     * @param $product
     * @return array
     */
    public function get_value( $product ) {
        
        return $product->get_id();
    }

    /**
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value, $rule ) {
        

        if( isset($rule['param']) && 'tag_not' === $rule['param'] ){
            $result = false;
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                $id = isset($cart_item['variation_id']) && $cart_item['variation_id'] !== 0 ? $cart_item['variation_id'] : $cart_item['product_id'];
                $tags  = get_the_terms( $id, 'product_tag' );
                if (isset($rule['value'])){
                    if( $tags  ){ 
                        foreach ($tags as $tag){
                            if (isset($tag->term_id) && $tag->term_id == $rule['value']){
                               return false;
                            }else{
                                $result = true;
                            }
                        }
                    }else{ 
                        $result = true;
                    }
                }
            }
            return $result;

        }else{
            $tags  = get_the_terms( $value, 'product_tag' );
            if (isset($rule['value'])){
                if( is_array( $tags ) ){
                    foreach ($tags as $tag){
                        if (isset($tag->term_id) && $tag->term_id == $rule['value']){
                            return true;
                        }
                    }
                }
            }
        }
        
        
        
        return false;
    }

}