<?php

namespace WPFunnelsProGBF\Conditions;

class Shipping extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product quantity from product object
     * 
     * @param Object $product
     * @return Number
     * 
     */
    public function get_value( $product = '' ){

        if( $product ){
           return $product->get_id();
        }
        return false;
    }


    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value = '', $rule = [] ) {
       
        if( $value && $rule ){
            $product = wc_get_product( $value );
            if( $product ){
                $class = $product->get_shipping_class();
                if( isset($rule['value']) && $class == $rule['value'] ){
                    return true;
                }
            }
            
        }
        return false;
    }
}