<?php

namespace WPFunnelsProGBF\Conditions;

class Role extends Wpfnl_Pro_GBF_Conditions {

    /**
     * 
     * @return array
     */
    function get_value() {
        if( is_user_logged_in() ) {
            $user = wp_get_current_user();
            if (isset($user->roles)){
                $roles = ( array ) $user->roles;
                return $roles; // This will returns an array
            }
        }
        return false;
    }


    /**
     * @param $value
     * @param $rule
     * @return bool
     */
    public function compare_to_rule( $value, $rule ) {
        if (is_array($value) && !empty($value) && isset($rule["value"]) && $rule["value"]){

            foreach ($value as $role){
                if ($role == $rule["value"]){
                    return true;
                }
            }
        }
        
        return false;
    }

}