<?php

namespace WPFunnelsProGBF\Conditions;

class Product extends Wpfnl_Pro_GBF_Conditions {

    /**
     * @param $product
     * @return array
     */
    public function get_value( $product ) {

        if ( $product ){
            return  $product->get_id();
        }
        return false;
    }


    /**
     * @param $value
     * @param $rule
     * @return bool
     */
    public function compare_to_rule( $value, $rule ) {
      
        if( !isset($rule['value']) ){
            return false;
        }
        $result = false;

        if( isset($rule['param']) && 'product_not' === $rule['param'] ){
            $product = wc_get_product($rule['value']);
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                if( $product ){
                    $id = isset($cart_item['variation_id']) && $cart_item['variation_id'] !== 0 ? $cart_item['variation_id'] : $cart_item['product_id'];
                   
                    if( 'variable' !== $product->get_type() && 'variable-subscription' !==  $product->get_type() ){
                        if( $id != $rule['value'] ){
                            $result = true;
                        }else{
                            return false;
                        }
                    }else{
                        $cart_product = wc_get_product($id);
                        if( $cart_product ){
                            $cart_product_id = $cart_product->get_parent_id() ? $cart_product->get_parent_id() : $cart_product->get_id();
                            if( $cart_product_id != $rule['value'] ){
                                $result = true;
                            }else{
                                return false;
                            }
                        }
                    }
                }
            
            }
            return $result;
        }else{
            $product = wc_get_product($rule['value']);
            
            if( $product ){
                if( 'variable' !== $product->get_type() && 'variable-subscription' !==  $product->get_type() ){
                    $result = ( $value == $rule['value'] );
                }else{
                    $cart_product = wc_get_product($value);
                    if( $cart_product ){
                        $cart_product_id = $cart_product->get_parent_id() ? $cart_product->get_parent_id() : $cart_product->get_id();
                        $result = ( $cart_product_id == $rule['value'] );
                    }
                }
            }
        }
        
        
        // Allow "all" to match any value.
        if ( 'any' === $rule['value'] ) {
            $result = true;
        }

        return $result;
    }

}