<?php

namespace WPFunnelsProGBF\Conditions;

class HighestPrice extends Wpfnl_Pro_GBF_Conditions {

    /**
     * get value
     *
     * @param $product
     * @return bool|mixed
     */
    public function get_value( $product ) {
        $funnel_id = $this->get_global_funnel_id_from_cookie();
        if( !$funnel_id ) {
            return false;
        }

        // get terms of the product
        $term       = $this->get_global_funnel_category( $funnel_id, $product );
        $category   = get_term( $term, 'product_cat' );

        $products = wc_get_products(array(
            'category' => array( $category->slug ),
        ));

        $all_prices[] = array();

        foreach ($products as $product) {
            $all_prices[] = $product->get_price();
        }

        return max($all_prices);
    }


    /**
     * @param $funnel_id
     * @param $product
     * @return bool|mixed
     */
    private function get_global_funnel_category( $funnel_id, $product ) {
        $gb_funnel_settings = wpfnl()->meta->get_funnel_meta( $funnel_id, 'global_funnel_data' );
        $terms              = $this->get_terms( $product );
        if( $gb_funnel_settings && isset($gb_funnel_settings['start_condition']) ) {
            $start_condition    = $gb_funnel_settings['start_condition'];
            $category           = false;
            foreach ( $start_condition  as $condition_group ) {
                if ( empty( $condition_group ) ) {
                    continue;
                }
                foreach ( $condition_group as $rule ) {
                    if( 'category' === $rule['param'] ) {
                        $category = array_intersect( $rule['value'], $terms );
                        break;
                    }
                }
                if($category) {
                    return current($category);
                }
            }
        }
        return false;
    }


    /**
     * get global funnel id from cookie
     *
     * @return int|mixed
     */
    private function get_global_funnel_id_from_cookie() {
        if( Wpfnl_functions::is_wc_active() ){
            return WC()->session->get('wpfunnels_global_funnel_id' );
        }
        return false;
    }


    /**
     * get categories of the product
     *
     * @param $product
     * @return array
     */
    private function get_terms( $product ) {
        $product_terms  = get_the_terms( $product->get_id(), 'product_cat' );
        $terms          = array();
        if( $product_terms ) {
            foreach ( $product_terms as $term ) {
                $terms[] = $term->term_id;
            }
        }
        return $terms;
    }

}