<?php

namespace WPFunnelsProGBF\Conditions;

class Category extends Wpfnl_Pro_GBF_Conditions {

    /**
     * @param $product
     * @return array
     */
    public function get_value( $product ) {
        $terms          = array();
        if( $product ){
            if( 'variation' === $product->get_type() || 'variable-subscription' ==  $product->get_type() || 'subscription_variation' ==  $product->get_type() ){
                $product_terms  = get_the_terms( $product->get_parent_id(), 'product_cat' );
            }else{
                $product_terms  = get_the_terms( $product->get_id(), 'product_cat' );
            } 
            if( $product_terms ) {
                foreach ( $product_terms as $term ) {
                    $terms[] = $term->term_id;
                }
            }
        }
        return $terms;
        
    }

    /**
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value, $rule ) {
        
       
        $result = $this->isSubset( $rule['value'], $value, (is_array($rule['value']) ? count($rule['value']) : 1 ), ( is_array($value) ? count($value) : 1 ) );
        
        // Reverse result for "!=" operator.
        if ( $rule['param'] === 'not_category' ) {
            return ! $result;
        }
        
        return $result;
    }


    /**
     * @param $arr1
     * @param $arr2
     * @param $m
     * @param $n
     * @return int
     */
    function isSubset( $arr1, $arr2, $m, $n )
    {
        
        $i = 0;
        $j = 0;
        $count = 0;
        for ($i = 0; $i < $n; $i++)
        {   
            for ($j = 0; $j <= $m; $j++)
            {   
               
                if(isset($arr2[$j])){
                    if($arr2[$j] == $arr1){
                        return 1;
                    }  
                }
                
            }
           
            if(isset($arr2[$i])){
            if($arr2[$i] == $arr1)
                return 1;
            }

            /* If the above inner loop was
            not broken at all then arr2[i]
            is not present in arr1[] */
            if ($j == $m)
                return 1;
        }

        /* If we reach here then all
        elements of arr2[] are present
        in arr1[] */
        return 0;
    }

}