<?php

namespace WPFunnelsProGBF\Conditions;
use Wpfnl_Pro_GB_Functions;


class ReturningCustomer extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product id from product object
     * 
     * @param Object $product
     * @return Number
     * @since 1.0.25
     */
    public function get_value( $product = '' ){
        if( $product ){
           return $product->get_id();
        }
        return false;
    }


    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     * @since 1.0.25
     */
    public function compare_to_rule( $value = '', $rule = [] ) {
       
        $is_returning = Wpfnl_Pro_GB_Functions::maybe_returning_user( get_current_user_id() );
        return $is_returning;
    
    }


}