<?php

namespace WPFunnelsProGBF\Conditions;

class Quantity extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product quantity from product object
     * 
     * @param Object $product
     * @return Number
     * 
     */
    public function get_value( $product = '' ){

        if( $product ){
            if( isset($product->quantity) ){
                return $product->quantity;
            }
           
        }
        return false;
    }

    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value = '', $rule = [] ) {

        if( $value && $rule ){
            if( 'quantity' === $rule['param'] ){
                if( $value == $rule['value'] ){
                    return true;
                }
            }elseif( 'quantity_greater' === $rule['param'] ){
                if( $value > $rule['value'] ){
                    return true;
                }
            }
        }
        return false;
    }


}