<?php

namespace WPFunnelsProGBF\Conditions;
use Wpfnl_Pro_GB_Functions;
use WPFunnels\Wpfnl_functions;

class Popular extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product quantity from product object
     * 
     * @param Object $product
     * @return Number
     * 
     */
    public function get_value( $product = '' ){

        if( $product ){
           return $product->get_id();
        }
        return false;
    }

    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value = '', $rule = [] ) {
        if ( empty( $value ) || empty( $rule ) || ! is_array( $rule ) ) {
            return false;
        }
        if( $value && $rule ){
            $rule_param = isset( $rule['param'] ) ? $rule['param'] : '';
            if( 'popular' === $rule_param ){
                $popular = Wpfnl_Pro_GB_Functions::get_most_popular_product(1);
                if( is_array($popular) && isset($popular['posts'][0]->ID) && Wpfnl_functions::is_wc_active() ){
                    //Check if the most popular product is a variable product
                    $product_id = $popular['posts'][0]->ID;
                    $product = wc_get_product($product_id);
                    $variation_ids = array();
                    
                    if ($product && $product->is_type('variable')) {
                        $variations = $product->get_children();

                        foreach ($variations as $variation_id) {
                            $variation = wc_get_product($variation_id);
                            $variation_ids[] = $variation->get_id();
                        }
                    }

                    if( $value === $popular['posts'][0]->ID || in_array($value, $variation_ids) ){
                        return true;
                    }
                    
                }   
            }
        }
        return false;
    }


}