<?php

namespace WPFunnelsProGBF\Conditions;
use Wpfnl_Pro_GB_Functions;


class Most_review extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product quantity from product object
     * 
     * @param Object $product
     * @return Number
     * 
     */
    public function get_value( $product = '' ){

        if( $product ){
           return $product->get_id();
        }
        return false;
    }

    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value = '', $rule = [] ) {
       
        if( $value && $rule ){
            if( 'most_review' === $rule['param'] ){
                $most_reviewed = Wpfnl_Pro_GB_Functions::get_most_reviewed_product(1);
                if( is_array($most_reviewed) && isset($most_reviewed['posts'][0]->ID)){
                    if( $value == $most_reviewed['posts'][0]->ID ){
                        return true;
                    }  
                }   
            }
        }
        return false;
    }


}