<?php

namespace WPFunnelsProGBF\Conditions;
use Wpfnl_Pro_GB_Functions;
use WPFunnels\Wpfnl_functions;

class Highest_sold extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product quantity from product object
     * 
     * @param Object $product
     * @return Number
     * 
     */
    public function get_value( $product = '' ){

        if( $product ){
           return $product->get_id();
        }
        return false;
    }

    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     * 
     * @since 1.1.3
     */
    public function compare_to_rule( $value = '', $rule = [] ) {
        if ( empty( $value ) || empty( $rule ) || ! is_array( $rule ) ) {
            return false;
        }
        
        if( $value && $rule ){
			$rule_param = isset( $rule['param'] ) ? $rule['param'] : '';
            
            if( 'highest_sold' ===  $rule_param  ){
                $highest_sold = Wpfnl_Pro_GB_Functions::get_highest_sold_product(1);
                
                if( is_array( $highest_sold ) && isset( $highest_sold[0] ) && Wpfnl_functions::is_wc_active()){
					//Check if the most popular product is a variable product
                    $product_id = $highest_sold[0]->id;
                    $product = wc_get_product($product_id);

                    $variation_ids = array();

                    if ($product && $product->is_type( 'variable' )) {
                        $variations = $product->get_children();

                        foreach ( $variations as $variation_id ) {
                            $variation = wc_get_product($variation_id) ;
                            $variation_ids[] = $variation->get_id();
                        }
                    }
                    
                    if( $value == $highest_sold[0]->id || in_array( $value, $variation_ids ) ){
                        return true;
                    }
                }   
            }
        }
        return false;
    }


}