<?php

namespace WPFunnelsProGBF\Conditions;
use Wpfnl_Pro_GB_Functions;


class Highest_rating extends Wpfnl_Pro_GBF_Conditions {


    /**
     * Get product quantity from product object
     * 
     * @param Object $product
     * @return Number
     * 
     */
    public function get_value( $product = '' ){

        if( $product ){
           return $product->get_id();
        }
        return false;
    }

    /**
     * Compare condition
     * @param $value
     * @param $rule
     * @return bool|void
     */
    public function compare_to_rule( $value = '', $rule = [] ) {
       
        if( $value && $rule ){
            if( 'highest_rating' === $rule['param'] ){
                $highest_rating = Wpfnl_Pro_GB_Functions::get_highest_avg_rating_product(1);
                if( is_array($highest_rating) && isset($highest_rating['posts'][0]->ID)){
                    if( $value == $highest_rating['posts'][0]->ID ){
                        return true;
                    }  
                }   
            }
        }
        return false;
    }


}