<?php 
namespace WPFunnelsProGBF\Conditions; 

use Wpfnl_Pro_GB_Functions; 
use \DateTime; 

/** 
 * @author [Getwpfunnels Team] 
 * @email [support@getwpfunnels.com]
 * @create date 2022-06-21 11:10:26 
 * @modify date 2022-06-21 11:10:26 
 * @desc [Enter funnel if current date should be in date range] 
 */ 

 class Date extends Wpfnl_Pro_GBF_Conditions { 

    /** 
     * Get current date while the cart is created 
     * @param Object $product 
     * @return Number || String || Bool 
     * 
    */ 
    public function get_value( $product = '' ){
        if( $product ){ 
            $date_created = new DateTime(); 
            return $date_created->format( "Y-m-d" ); 
        } 
        return false; 
    } 
    
    
    /** 
     * Compare condition 
     * @param $current_date 
     * @param $rule 
     * @return bool|void 
     * 
    */ 
    public function compare_to_rule( $current_date = '', $rule = [] ) { 
        if( $current_date && $rule ){ 
            if( 'date' === $rule['param'] ){ 
                $date = Wpfnl_Pro_GB_Functions::date_is_similiar_to_current_date( $current_date, $rule ); 
                return $date; 
            } 
        } 
        return false; 
    } 
}