<?php

namespace WPFunnelsProGB\Actions;

use WC_Product;
use Wpfnl_Pro_GBF_Conditions_Factory;
use Wpfnl_Pro_GBF_Offer_Conditions_Factory;
use WPFunnels\Traits\SingletonTrait;
use WPFunnels\Wpfnl_functions;
use Wpfnl_Pro_GB_Functions;
use WPFunnelsPro\Wpfnl_Pro_functions;

/**
 * Class Wpfnl_Pro_GB_Actions
 * @package WPFunnelsProGB\Actions
 */
class Wpfnl_Pro_GB_Actions {

    use SingletonTrait;

    public $ob_product_id;
    public $cart_product_id;
    public $offer_product_id;

    public function __construct() {
       
        add_filter( 'wpfunnels/addon-lists', array($this, 'register_addon_for_licensing') );

        add_filter( 'wpfunnels/is_global_funnel_activated', array( $this, 'is_global_funnel_activated' ), 10 );
        add_filter( 'wpfunnels/is_global_funnel', array( $this, 'may_be_global_funnel' ), 10, 2 );

        add_action( 'init', array( $this, 'check_redirect_to_funnel_checkout' ) );

        add_filter( 'wpfunnels/funnel_products', array( $this, 'initialize_global_funnel_products' ), 10, 3 );
//        add_filter( 'wpfunnels/order_bump_settings', array( $this, 'initialize_global_funnel_order_bump' ), 10, 3 );
        add_filter( 'wpfunnels/offer_product_data', array( $this, 'initialize_global_funnel_offer_products' ), 10, 3 );

        // offer product data for backend
        add_filter( 'wpfunnels/upsell_product', array( $this, 'get_upsell_product' ), 10, 2);
        add_filter( 'wpfunnels/downsell_product', array( $this, 'get_downsell_product' ), 10, 2);

        add_action( 'wpfunnels/funnel_journey_end', array( $this, 'remove_all_cookie' ), 10, 2 );
        add_filter( 'wpfunnels/disable_funnel_view_button', array($this, 'disable_view_button'), 10, 2 );

        add_action('template_redirect', [ $this, 'maybe_skip_step' ]);

       
    }

    /**
     * Check wp_loaded class are loaded and redirect to  checkout url
     * @since 1.0.8
     */
    public function check_redirect_to_funnel_checkout(){
        $is_gbf_check = apply_filters('wpfunnels/check_global_funnel_conditions', true );
        if( $is_gbf_check ){
            add_filter( 'woocommerce_get_checkout_url', array( $this, 'redirect_to_funnel_checkout' ), 10, 1);
        }
    }


    /**
     * Register GBF addon for licensing
     *
     * @param array $addons array  
     * 
     * @return array
     *
     * @since 1.0.3
     */
    public function register_addon_for_licensing( $addons ) {
        $addons['global_funnel']['key']             = 'gbf';
        $addons['global_funnel']['name']            = __( 'Global Funnels for WooCommerce', 'wpfnl-pro' );
        $addons['global_funnel']['description']     = __( 'Send buyers into a sales funnel directly from your WooCommerce store.', 'wpfnl-pro' );
        $addons['global_funnel']['icon']            = WPFNL_PRO_DIR . '/admin/partials/icons/global-funnel-icon.php';
        $addons['global_funnel']['slug']            = 'wpfunnels-pro-gbf/wpfnl-pro-gb.php';
        // $addons['global_funnel']['plugin_status']   = 'installed';
        $addons['global_funnel']['plugin_status']   = 'activated';
        $addons['global_funnel']['license_key']     = get_option( 'wpfunnels_pro_gbf_license_key');
        $addons['global_funnel']['license_data']    = get_option( 'wpfunnels_pro_gbf_license_data' );
        $addons['global_funnel']['license_status']  = get_option( 'wpfunnels_pro_gbf_license_status' );
        $addons['global_funnel']['product_id']      = WPFNL_PRO_GB_PRODUCT_ID;
        $addons['global_funnel']['version']         = WPFNL_PRO_GB_VERSION;
        $addons['global_funnel']['dependency']      = 'pro';
        $addons['global_funnel']['btn_txt']      = $this->get_button_text('wpfunnels-pro-gbf/wpfnl-pro-gb.php');
        $addons['global_funnel']['btn_link']      = $this->check_plugin_installed('wpfunnels-pro-gbf/wpfnl-pro-gb.php') ? admin_url('plugins.php') : 'https://getwpfunnels.com/pricing/';
        return $addons;
    }


    /**
     * get button text
     *
     * @param $slug
     * @return string|void
     *
     * @since 1.0.24
     */
    public function get_button_text( $slug ) {
        if ( !$this->check_plugin_installed( $slug ) ) {
            return __('Get the add-on', 'wpfnl-pro-gbf');
        }

        if ( is_plugin_active( $slug ) ) {
            return __('Activated', 'wpfnl-pro-gbf');
        }
        return __('Please enable', 'wpfnl-pro-gbf');
    }


    /**
     * check if plugin is installed
     *
     * @param $plugin_slug
     * @return bool
     * @since 1.0.24
     */
    public function check_plugin_installed( $plugin_slug ) {
        if ( ! function_exists( 'get_plugins' ) || ! function_exists( 'is_plugin_active' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $installed_plugins = get_plugins();
        return array_key_exists( $plugin_slug, $installed_plugins ) || in_array( $plugin_slug, $installed_plugins, true );
    }

    /**
     * return true if this plugin is activated
     *
     * @return bool
     */
    public function is_global_funnel_activated() {
        return true;
    }


    /**
     * check if this funnels is saved as global funnel or not
     *
     * @param $result
     * @param $funnel_id
     * @return bool
     */
    public function may_be_global_funnel( $result, $funnel_id ) {
        return $this->is_global_funnel($funnel_id);
    }


    /**
     * modify cart page redirect url if any global funnel
     * found for the cart data
     *
     * @param $redirect_url
     * @return string
     */
    public function redirect_to_funnel_checkout( $redirect_url ) {
         
        $cookie_products = array();
        
        
        if( WC()->cart && !is_checkout() ) {
            $cart_total = WC()->cart->get_totals();

            $coupons = WC()->cart->get_applied_coupons();
            @setcookie( 'wpfnl_gbf_coupon', wp_json_encode($coupons) , time() + 3600, '/', COOKIE_DOMAIN );
            
            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                $global_funnels = $this->get_activated_global_funnels();
                if( $global_funnels ){
                    foreach ( $global_funnels as $funnel ) {
                        $funnel_id = $funnel->ID;
                        $gb_funnel_settings = wpfnl()->meta->get_funnel_meta( $funnel_id, 'global_funnel_start_condition' );

                        if( $gb_funnel_settings && is_array( $gb_funnel_settings ) ) {
                            
                            $product = wc_get_product( isset($cart_item['variation_id']) && $cart_item['variation_id'] !== 0 ? $cart_item['variation_id'] : $cart_item['product_id'] );
                            
                            $should_trigger_gb_funnels =  $this->should_trigger_gb_funnel( $funnel_id, $product, $gb_funnel_settings, $cart_total['total'], $cart_item['quantity']);
                            if( $cart_item['variation_id'] ){
                                $formatted_variation = array();
                                foreach( $cart_item['variation'] as $key=>$variation ){
                                    $key = str_replace("attribute_","",$key);
                                    $formatted_variation['attribute_'.$key] = $variation;
                                }
                                
                                $data           = array(
                                    'id'            => $cart_item['product_id'],
                                    'variation_id'  => $cart_item['variation_id'],
                                    'variations'    => $formatted_variation,
                                    'quantity'      => $cart_item['quantity'],
                                    'discount_type' => '',
                                    'discount_value'=> '',
                                    'funnel_id'     => $funnel_id,
                                );
                            }else{
                                $data           = array(
                                    'id'            => $cart_item['product_id'],
                                    'quantity'      => $cart_item['quantity'],
                                    'discount_type' => '',
                                    'discount_value'=> '',
                                    'funnel_id'     => $funnel_id,
                                );
                            }                            

                            array_push($cookie_products,$data);
                            WC()->session->set('wpfunnels_global_funnel_product', $cookie_products);
                            
                            if( !$should_trigger_gb_funnels ) {
                                continue;
                            }
                            $gbf_products = array();
                          
                            if( $cart_item['variation_id'] ){
                                $formatted_variation = array();
                                foreach( $cart_item['variation'] as $key=>$variation ){
                                    $key = str_replace("attribute_","",$key);
                                    $formatted_variation['attribute_'.$key] = $variation;
                                }
                                
                                $gbf_data           = array(
                                    'id'            => $cart_item['product_id'],
                                    'variation_id'  => $cart_item['variation_id'],
                                    'variations'    => $formatted_variation,
                                    'quantity'      => $cart_item['quantity'],
                                    'discount_type' => '',
                                    'discount_value'=> '',
                                    'funnel_id'     => $funnel_id,
                                );
                            }else{
                                $gbf_data           = array(
                                    'id'            => $cart_item['product_id'],
                                    'quantity'      => $cart_item['quantity'],
                                    'discount_type' => '',
                                    'discount_value'=> '',
                                    'funnel_id'     => $funnel_id,
                                );
                            }                            

                            array_push($gbf_products,$gbf_data);
                            WC()->session->set('wpfunnels_global_funnel_specific_product', $gbf_products);

                            WC()->session->set('wpfunnels_global_funnel_id', $funnel_id);
                            
                            $steps = Wpfnl_functions::get_steps($funnel_id);
                            if( !$steps ){
                                return $redirect_url;
                            }
                            $key = array_search('checkout', array_column($steps, 'step_type'));
                            $step_id = '';
                            if( $key !== false ){
                                $step_id = $steps[$key]['id'];
                            }
                            if( !$step_id ){
                                return $redirect_url;
                            }

                            $redirect_url = add_query_arg(
                                'global_funnel',
                                'yes',
                                esc_url( get_permalink($step_id) )
                            );
                            break;
                        }
                    }
                }
            }
           
        }
        
        return $redirect_url;
    }


    /**
     * Get active global funnel data
     * 
     */
    private function get_activated_global_funnels(){
        $global_funnels     = get_posts(
            array(
                'numberposts'   => -1,
                'post_type'     => WPFNL_FUNNELS_POST_TYPE,
                'post_status'   => 'publish',
                'fields'        => 'ID',
                "orderby" => "date",
                "order" => 'ASC',
                'meta_query'    => array(
                    array(
                        'key'       => 'is_global_funnel',
                        'compare'   => '=',
                        'value'     => 'yes',
                    ),
                    
                )
            )
        );
        return $global_funnels;
    }


    /**
     * check if the product is marked as global funnel products
     *
     * @param $funnel_id
     * @param $start_condition
     * @return bool
     */
    private function should_trigger_gb_funnel( $funnel_id, $product, $start_condition, $cart_total, $cart_item) {
        return $this->compare_condition( $start_condition, $product, $cart_total, $cart_item );
    }


    /**
     * compare condition
     *
     * @param $group
     * @param $value
     * @return bool
     */
    private function compare_condition( $group, $value, $cart_total, $quantity ) {
        
        foreach ( $group as $condition_group ) {

            if ( empty( $condition_group ) ) {
                continue;
            }
            $match_group = true;
            if( is_array($condition_group) ){
                if ( ! $this->match_rule( $condition_group, $value, $cart_total, $quantity) ) {
                    $match_group = false;
                }
            }
            if ( $match_group ) {
                return true;
            }
        }
        return false;
    }
    

    /**
     * @param $rule
     * @param $param
     * @return bool
     */
    private function match_rule( $rule, $param, $cart_total, $quantity) {
        $result     = false;
        if( !isset($rule['param']) || !$rule['param'] ){
            return false;
        }

        $key = strpos($rule['param'],"cart_total"); 
        $param_type = wpfnl_pro_gb_get_param_type( $rule );
        if ( $param_type ) {
            if( false !== $key ){
                $value  = $cart_total;
                $result = $param_type->compare_to_rule( $value, $rule );
            }else{
                $key = strpos($rule['param'],"quantity");
                if( false !== $key ){
                    $param = (object) array_merge( (array)$param, array( 'quantity' => $quantity ) );
                }
                $value  = $param_type->get_value( $param );
                $result = $param_type->compare_to_rule( $value, $rule );
            }
        }
        
        return $result;
    }


    /**
     * initialize checkout main products for global
     * funnel
     *
     * @param $product_array
     * @param $funnel_id
     * @param $step_id
     * @return array
     */
    public function initialize_global_funnel_products( $product_array, $funnel_id, $step_id ) {
        $is_global_funnel   = $this->is_global_funnel($funnel_id);
        $products           = array();
        if( !$is_global_funnel ) {
            return $product_array;
        }
        if( $is_global_funnel ) {
            $cookie_products = $this->get_global_funnel_product_from_cookie();
            // check if any product id is found on cache for global funnel
            if( !$cookie_products && !is_array($cookie_products) ) {
                return $product_array;
            }
            
            // $product = wc_get_product( $cookie_products['id'] );
            // if( !$product ) {
            //     return $product_array;
            // }
          
            $gb_funnel_settings = wpfnl()->meta->get_funnel_meta( $funnel_id, 'global_funnel_start_condition' );
            if( $gb_funnel_settings && is_array( $gb_funnel_settings ) ) {

                $should_trigger_gb_funnels = false;
                
                foreach( $cookie_products as $cookie_product ){
                    $products[] = $cookie_product;
                }
                if( !$should_trigger_gb_funnels ) {
                    return $products;
                }
                return $products;
            }
        }
        return $product_array;
    }


    /**
     * @param $ob_settings
     * @param $funnel_id
     * @param $step_id
     * @return array
     */
    public function initialize_global_funnel_order_bump( $ob_settings, $funnel_id, $step_id ) {
        $is_global_funnel   = $this->is_global_funnel($funnel_id);
        if( !$is_global_funnel ) {
            return $ob_settings;
        }

        if( $is_global_funnel ) {
            $gb_funnel_settings = wpfnl()->meta->get_funnel_meta( $funnel_id, 'global_funnel_start_condition' );
            if( $gb_funnel_settings && is_array( $gb_funnel_settings ) ) {
                $ob_mappings = wpfnl()->meta->get_funnel_meta( $step_id, 'global_funnel_ob_rules' );
                if( $ob_mappings ){
                    $this->ob_product_id = $ob_mappings['show'];
                    $product = wc_get_product($ob_mappings['show']);
                    $product_image = $this->get_ob_matched_product($ob_mappings['show']);
                    $price = wc_price($product->get_regular_price());
                    $ob_settings['productName']     = $product->get_title();
                    $ob_settings['price']           = $price;
                    $ob_settings['htmlPrice']       = $price;
                    $ob_settings['salePrice']       = $product->get_sale_price();
                    $ob_settings['product']         = $ob_mappings['show'];
                    $ob_settings['quantity']        = $ob_mappings['quantity'];
                    $ob_settings['productImage']    = $product_image['productImage'];
                    $ob_settings['highLightText']   = '';
                    $ob_settings['isEnabled']       = 'hello';
                }
                return $ob_settings;
            }
        }
        return $ob_settings;
    }


    /**
     * get global funnel ob product
     *
     * @param $ob_mappings
     * @param $product
     * @return array|mixed
     */
    private function get_ob_product( $ob_mappings, $product ) {
        $ob_product = array();
        foreach ( $ob_mappings as $condition_group ) {
            if ( empty( $condition_group ) ) {
                continue;
            }
            
            $match_group = true;
           
            if( is_array($condition_group) ){
                foreach ( $condition_group as $rule ) {
                    
                    if ( !$this->match_rule( $rule, $product ) ) {
                        
                        $match_group = false;
                        break;
                    } else {
                        
                        if( $rule['show'] === 'highestValue'){
                            $limit = 3;
                            $ids  = $this->get_best_selling_product( $limit );
                            foreach( WC()->cart->get_cart() as $cart_item ){
                                $this->cart_product_id = $cart_item['product_id'];
                            }
                            $this->ob_product_id = ( $ids[0]->id !==  $this->cart_product_id ) ? $ids[0]->id : $ids[1]->id;
                            $ob_product  = $this->get_ob_matched_product( $this->ob_product_id );
                        }else{
                            
                            $ob_product  = $this->get_ob_matched_product( $rule['show'] );
                        }
                    }
                }
            }else{

                $ob_product  = $this->get_ob_matched_product( $condition_group );

            }
            if ( $match_group ) {
                return $ob_product;
            }
        }
        return $ob_product;
    }

    /**
     * Get Order bump matched product by product ID
     * 
     * @param $id 
     * 
     * @return 
     */
    private function get_ob_matched_product( $id ){
        
        $img = wp_get_attachment_image_src(get_post_thumbnail_id($id), 'single-post-thumbnail');
        $img = $img[0];
        $product = array(
            'id'        => $id,
            'quantity'  => 1,
            'productImage' => array(
                'id'    => get_post_thumbnail_id($id),
                'url'   => $img
            )
        );
        return $product;

    }


    /**
     * @return int|mixed
     */
    private function get_global_funnel_offer_product_from_cookie() {
        $cookie_name    = 'wpfunnels_global_funnel_offer_product';
        return isset( $_COOKIE[$cookie_name] ) ? json_decode( wp_unslash( $_COOKIE[$cookie_name] ), true ) : array();
    }
    
    /**
     * @return int|mixed
     */
    private function get_global_funnel_product_from_cookie() {
        if( Wpfnl_functions::is_wc_active() ){
            $cookie_name    = 'wpfunnels_global_funnel_product';
            return WC()->session->get('wpfunnels_global_funnel_product');
        }
        return false;
    }

    /**
     * @return int|mixed
     */
    private function get_gbf_product_from_cookie() {
        if( Wpfnl_functions::is_wc_active() ){
            return WC()->session->get('wpfunnels_global_funnel_specific_product') ? WC()->session->get('wpfunnels_global_funnel_specific_product') : [];
        }
        return [];
    }


    /**
     * Get best sale product
     * 
     * @param $limit
     */
    private function get_best_selling_product( $limit = '-1' ){
        global $wpdb;
    
        $limit_clause = intval($limit) <= 0 ? '' : 'LIMIT '. intval($limit);
       
        return (array) $wpdb->get_results("
            SELECT p.ID as id, COUNT(oim2.meta_value) as count
            FROM {$wpdb->prefix}posts p
            INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim
                ON p.ID = oim.meta_value
            INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim2
                ON oim.order_item_id = oim2.order_item_id
            INNER JOIN {$wpdb->prefix}woocommerce_order_items oi
                ON oim.order_item_id = oi.order_item_id
            INNER JOIN {$wpdb->prefix}posts as o
                ON o.ID = oi.order_id
            WHERE p.post_type = 'product'
            AND p.post_status = 'publish'
            AND oim.meta_key = '_product_id'
            GROUP BY p.ID
            ORDER BY COUNT(oim2.meta_value) + 0 DESC
            $limit_clause
        ");
    }


    /**
     * initialize global funnel offer products
     *
     * @param $offer_product
     * @param $funnel_id
     * @param $step_id
     * @return array
     */
    public function initialize_global_funnel_offer_products( $offer_product, $funnel_id, $step_id ) {
        $is_global_funnel   = $this->is_global_funnel($funnel_id);
        $order_id           = ( isset( $_POST['order_id'] ) ) ? intval( $_POST['order_id'] ) : (( isset( $_GET['wpfnl-order'] ) ) ? intval( $_GET['wpfnl-order'] ) : 0);
        $step_type          = get_post_meta($step_id, '_step_type', true);
        
        if( !$is_global_funnel ) {
            return $offer_product;
        }
        if( !$order_id ) {
            return $offer_product;
        }
        $is_offer_clicked = isset( $offer_product['offer_button'] ) && 'yes' === $offer_product['offer_button'] ? true : false;
        $prev_offer_product = $offer_product;
        $gbf_product = $this->get_gbf_product_from_cookie();
        if( $is_global_funnel ) {
            $gb_funnel_settings = wpfnl()->meta->get_funnel_meta( $funnel_id, 'global_funnel_start_condition' );
            
            if( $gb_funnel_settings && is_array( $gb_funnel_settings ) ) {
                $offer_mappings  = wpfnl()->meta->get_funnel_meta( $step_id, "global_funnel_{$step_type}_rules" );
                if( isset($offer_mappings['type']) ){
                    $param_type = Wpfnl_Pro_GBF_Offer_Conditions_Factory::build($offer_mappings['type']);
                    $offer_product   = $param_type->get_offer_product( $offer_mappings, $order_id, $step_id, $gbf_product );
                    $_offer_product = isset( $offer_product['id'] ) ? wc_get_product( $offer_product['id'] ) : null;
                    if( $_offer_product && $_offer_product instanceof WC_Product){
                        if( $_offer_product->get_type() == 'variable' && $is_offer_clicked ){
                            return $prev_offer_product;
                        }
                    }
                    
                }
            }
        }

        if( isset( $offer_product['unit_price'], $offer_product['unit_price_tax'], $offer_product['args']['subtotal'], $offer_product['args']['total'], $offer_product['total'] ) ){
            $offer_product['unit_price'] = floatval(preg_replace("/[^-0-9\.]/","",$offer_product['unit_price']));
            $offer_product['unit_price_tax'] = floatval(preg_replace("/[^-0-9\.]/","",$offer_product['unit_price_tax']));
            $offer_product['args']['subtotal'] = floatval(preg_replace("/[^-0-9\.]/","",$offer_product['args']['subtotal']));
            $offer_product['args']['total'] = floatval(preg_replace("/[^-0-9\.]/","",$offer_product['args']['total']));
            $offer_product['total'] = floatval(preg_replace("/[^-0-9\.]/","",$offer_product['total']));
        }
        
        return $offer_product;
    }


    /**
     * check if the funnel is global funnel or not
     *
     * @param $funnel_id
     * @return bool|string
     */
    private function is_global_funnel( $funnel_id ) {
        $is_global_funnel = wpfnl()->meta->get_funnel_meta( $funnel_id, 'is_global_funnel' );
        if( 'yes' === $is_global_funnel ) {
            return true;
        }
        return false;
    }


    /**
     * get param list for rule matching, may be order, product, category, tags
     *
     * @param $rule
     * @param $param_list
     * @return mixed
     */
    private function get_rule_param_for_offer( $rule, $param_list ) {
        return $param_list[$rule['param']];
    }


    /**
     * delete array values
     *
     * @param array $arr
     * @param array $remove
     * @return array
     */
    function delete_array_values(array $arr, array $remove) {
//        return array_filter($arr, fn($e) => !in_array($e, $remove));
        $index = array_search($remove[0], $arr);
        if($index !== false){
            unset($arr[$index]);  // $arr = ['b', 'c']
        }
        return $arr;
    }

    /**
     * Get upsell product from postmeta by step id
     */
    public function get_upsell_product( $product, $step_id ){
        $funnel_id = Wpfnl_functions::get_funnel_id_from_step( $step_id );
       
        if(!$this->is_global_funnel($funnel_id)) {
            return $product;
        }
        $upsell_rules   = get_post_meta( $step_id, 'global_funnel_upsell_rules', true );
        
        $products = array();
        if($upsell_rules) {
            $products[0]['id'] = $upsell_rules['show'];
            $products[0]['quantity'] = $upsell_rules['quantity'];
            $product = $products;
        }
        

        return $product;
    }
    
    /**
     * Get downsell product from postmeta by step id
     */
    public function get_downsell_product( $product, $step_id ){
        $funnel_id = Wpfnl_functions::get_funnel_id_from_step( $step_id );
        if(!$this->is_global_funnel($funnel_id)) {
            return $product;
        }
        $downsell_rules   = get_post_meta( $step_id, 'global_funnel_downsell_rules', true );
        $products = array();
        if($downsell_rules) {
            $products[0]['id'] = $downsell_rules['show'];
            $products[0]['quantity'] = $downsell_rules['quantity'];
            $product = $products;
        }
        
        return $product;
    }


    /**
     * disable funnel view button for global funnel
     *
     * @param $disable
     * @param $funnel_id
     * @return boolean
     */
    public function disable_view_button( $disable, $funnel_id ) {
        $is_global_funnel = $this->is_global_funnel($funnel_id);
        return $is_global_funnel ? $is_global_funnel : $disable;
    }


    /**
     * Remove all cookie when enter in tankyou page
     *
     * @param $step_id
     * @param $funnel_id
     */
    public function remove_all_cookie( $step_id, $funnel_id ) {
        if( Wpfnl_functions::is_wc_active() ){
            WC()->session->set('wpfunnels_global_funnel_product', null);
            WC()->session->set('wpfunnels_global_funnel_id', null);
            WC()->session->set('wpfunnels_global_funnel_specific_product', null);
        }
        
    }

    /**
     * Check gfb enable or not by funnel id
     */
    private function is_enable_gbf(){
        $post_data  = array();
        if( isset($_POST['post_data']) ){
            parse_str($postData, $post_data);
            $is_enabled = get_post_meta( $post_data['_wpfunnels_funnel_id'], 'is_global_funnel', true );
            if( $is_enabled == 'yes' ){
                return true;
            }
            return false;
        }
    }

    /**
     * Maybe skip step
     *
     * @since 1.0.9
     */
    public function maybe_skip_step()
    {
        
        global $post;
        
        if( $post ){
            $step_id   = $post->ID;
            $funnel_id = get_post_meta( $post->ID, '_funnel_id', true );
            $step_type = get_post_meta( $post->ID, '_step_type', true );
          
            if( $funnel_id ){
                $order_id = Wpfnl_functions::get_order_id_from_post_data();

                if( 'checkout' === $step_type ){
                    add_filter('wpfunnels/order_bump_settings', [$this,'update_ob_settings'], 10, 3 );
                }
                if( 'upsell' === $step_type || 'downsell' === $step_type ){
                    $main_products = $this->get_global_funnel_product_from_cookie();
                    $offer_products = get_post_meta( $step_id, 'global_funnel_'.$step_type.'_rules', true );
                    $order_id = isset($_GET['wpfnl-order']) ? $_GET['wpfnl-order'] : 0 ;
                    $order_key = isset($_GET['wpfnl-key']) ? $_GET['wpfnl-key'] : '' ;
                    $is_matched = Wpfnl_Pro_GB_Functions::maybe_match( $funnel_id,$offer_products,$main_products );
                    if( $is_matched ){
                        $next_step = Wpfnl_functions::get_next_step( $funnel_id, $step_id );
                        if ($next_step) {
                            if ( 'conditional' === $next_step['step_type'] ) {
                                $next_step = Wpfnl_functions::get_next_step( $funnel_id, $next_step['step_id'] );
                            }
                            $redirect_url = get_permalink( $next_step['step_id'] );
                            $redirect_url = $redirect_url.'?wpfnl-order='.$order_id.'&wpfnl-key='.$order_key;
                            wp_safe_redirect($redirect_url);
                            exit;
                        }
                    }
                }

            }
        }
    }


    /**
     * update ob settings
     * 
     */
    public function update_ob_settings( $ob_products, $funnel_id, $step_id ){
        
        $main_products = $this->get_global_funnel_product_from_cookie();
        $ob_products = Wpfnl_Pro_GB_Functions::maybe_ob_match( $funnel_id,$ob_products,$main_products );
        return $ob_products;      
    }   


}

if( !function_exists('wpfnl_pro_gb_get_param_type') ) {
    function wpfnl_pro_gb_get_param_type( $rule ) {
        if( 'all_product' == $rule['param'] || 'product_not' == $rule['param'] ){
            $rule['param'] = 'product';
        }

        if( 'tag_not' == $rule['param'] ){
            $rule['param'] = 'tag';
        }

        if( 'not_category' == $rule['param'] ){
            $rule['param'] = 'category';
        }

        $cart_key = strpos($rule['param'],"cart_total"); 
        if( false !== $cart_key ){
            $operator = str_replace('cart_total_','',$rule['param']);
            $rule['param'] = 'cart_total';
        }
        $quantity_greater_key = strpos($rule['param'],"quantity_greater"); 
        if( false !== $quantity_greater_key ){
            $operator = str_replace('cart_total_','',$rule['param']);
            $rule['param'] = 'quantity';
        }
        
        $param_type = Wpfnl_Pro_GBF_Conditions_Factory::build($rule['param']);
        return $param_type;
    }
}