<?php
namespace WPFunnelsProGB;

use Wpfnl_Pro_Gb_Admin;
use Wpfnl_Pro_Gb_i18n;
use Wpfnl_Pro_Gb_Loader;
use Wpfnl_Pro_Gb_Public;
use WPFunnelsProGB\Actions\Wpfnl_Pro_GB_Actions;
use WPFunnelsProGBF\Admin\Modules\GlobalCheckout\Wpfnl_Global_Checkout_Ajax;

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://getwpfunnels.com/
 * @since      1.0.0
 *
 * @package    Wpfnl_Pro_Gb
 * @subpackage Wpfnl_Pro_Gb/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Wpfnl_Pro_Gb
 * @subpackage Wpfnl_Pro_Gb/includes
 * @author     WPFunnels Team <support@getwpfunnels.com>
 */
class Wpfnl_Pro_Gb {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Wpfnl_Pro_Gb_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	protected $global_funnel;


	public $license;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'WPFNL_PRO_GB_VERSION' ) ) {
			$this->version = WPFNL_PRO_GB_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'wpfnl-pro-gb';

		$this->load_dependencies();
		$this->set_locale();
        add_action( 'plugins_loaded', array( $this, 'init' ), 100 );
		$this->define_admin_hooks();
		// $this->define_public_hooks();

		
	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Wpfnl_Pro_Gb_Loader. Orchestrates the hooks of the plugin.
	 * - Wpfnl_Pro_Gb_i18n. Defines internationalization functionality.
	 * - Wpfnl_Pro_Gb_Admin. Defines all hooks for the admin area.
	 * - Wpfnl_Pro_Gb_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

        /**
         * The class responsible for auto loading all files of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'vendor/autoload.php';

        /**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/utils/class-wpfnl-pro-gb-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/utils/class-wpfnl-pro-gb-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-wpfnl-pro-gb-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-wpfnl-pro-gb-public.php';

		$this->loader = new Wpfnl_Pro_Gb_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Wpfnl_Pro_Gb_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Wpfnl_Pro_Gb_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}


	public function init() {
        if ( did_action( 'wpfunnels/init' ) ) {
            $this->global_funnel = Wpfnl_Pro_GB_Actions::getInstance();
            // $this->license       = Wpfnl_Pro_GBF_Licensing::getInstance();
        }
    }

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {
		
		$plugins = get_option('active_plugins');
		if( ( function_exists('is_plugin_active') && is_plugin_active( 'wpfunnels/wpfnl.php' ) && is_plugin_active( 'wpfunnels-pro/wpfnl-pro.php' ) ) || ( in_array('wpfunnels/wpfnl.php',$plugins) && in_array('wpfunnels-pro/wpfnl-pro.php',$plugins) ) ){
				$plugin_admin = new Wpfnl_Pro_Gb_Admin( $this->get_plugin_name(), $this->get_version() );
				$plugin_admin_ajax = new Wpfnl_Global_Checkout_Ajax();
				$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
				$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
				$this->loader->add_action( 'admin_init', $plugin_admin_ajax, 'init');
				$this->loader->add_filter( 'wpfunnels/supported-addons', $plugin_admin, 'update_gbf_condition', 10, 1);
				$this->loader->add_filter( 'wpfunnels/supported-gbf-offer-condition', $plugin_admin, 'update_gbf_offer_condition', 10, 1);
				$this->loader->add_filter( 'wpfunnels/check_update_transient', $plugin_admin , 'check_update_transient' );
		}

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Wpfnl_Pro_Gb_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Wpfnl_Pro_Gb_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
