<?php

namespace WPFunnelsProGBF\Admin\Modules\GlobalCheckout;

class Wpfnl_Global_Checkout_Ajax{

    public function init()
    {
		wp_ajax_helper()->handle('wpfnl-enable-global-funnel')
            ->with_callback([ $this, 'wpfnl_enable_global_funnel' ])
            ->with_validation($this->get_validation_data());
            
        wp_ajax_helper()->handle('wpfnl-get-enable-global-funnel-data')
            ->with_callback([ $this, 'wpfnl_get_enable_global_funnel_data' ])
            ->with_validation($this->get_validation_data());

    }

    /**
     * Validate data
     */
    public function get_validation_data()
    {
        return[
            'logged_in' => true,
            'user_can' => 'manage_options',
        ];
    }


    /**
     * Enable global checkout option
     */
    public function wpfnl_enable_global_funnel( $payload ){
        $funnel_id  = $payload['funnel_id'];
        $data       = get_post_meta( $payload['funnel_id'], 'is_global_funnel', true );
       
        if($data === 'yes' ){
            update_post_meta( $funnel_id, 'is_global_funnel', 'no' );
            $data = get_post_meta( $payload['funnel_id'], 'is_global_funnel', true );
        }else{
            update_post_meta( $funnel_id, 'is_global_funnel', 'yes' );
            $data = get_post_meta( $payload['funnel_id'], 'is_global_funnel', true );
        }
        return [
            'status' => 'success',
            'data'   => $data
        ]; 
    }

    /**
     * 
     */
    public function wpfnl_get_enable_global_funnel_data( $payload ){
        $data = get_post_meta( $payload['funnel_id'], 'is_global_funnel', true );
        return [
            'status' => 'success',
            'data'   => $data
        ];
    }
}